package com.quiz.client;
import com.quiz.common.*;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Scanner;

public class QuizClient extends UnicastRemoteObject implements QuizCallback {

    private QuizService service;
    private String studentName;

    protected QuizClient(String name) throws Exception {
        super();
        this.studentName = name;
        Registry registry = LocateRegistry.getRegistry("localhost", 1099);
        service = (QuizService) registry.lookup("QuizService");
        service.registerCallback(studentName, this);
    }

    @Override
    public void updateLeaderboard(String leaderboard) {
        System.out.println("\n--- Leaderboard Update ---\n" + leaderboard);
    }

    public void start() throws Exception {
        Scanner sc = new Scanner(System.in);
        while (true) {
            Question q = service.getQuestion(studentName);
            System.out.println("Question: " + q.getQuestion());
            System.out.print("Your Answer: ");
            String ans = sc.nextLine();
            String feedback = service.submitAnswer(studentName, ans);
            System.out.println(feedback);
        }
    }

    public static void main(String[] args) throws Exception {
        Scanner sc = new Scanner(System.in);
        System.out.print("Enter your name: ");
        String name = sc.nextLine();
        QuizClient client = new QuizClient(name);
        client.start();
    }
}
