\documentclass[12pt, a4paper]{article}
\usepackage[utf8]{inputenc}
\usepackage{array}
\usepackage{longtable} 
\usepackage[margin=0.7in]{geometry}

% Define centered column types
\newcolumntype{C}[1]{>{\centering\arraybackslash}p{#1}}

\begin{document}

\section*{MPI Manual Reduce Performance Scaling Study}

\renewcommand{\arraystretch}{1.5}
\begin{longtable}{|C{4.5cm}|C{2.5cm}|C{2.5cm}|C{2.5cm}|C{2.5cm}|}
\hline
\textbf{Cluster Topology} & \textbf{Parallel Time} & \textbf{Processors} & \textbf{Serial Time} & \textbf{Array Size (N)} \\ \hline
\endfirsthead
\hline
\textbf{Cluster Topology} & \textbf{Parallel Time} & \textbf{Processors} & \textbf{Serial Time} & \textbf{Array Size (N)} \\ \hline
\endhead

cluster\_fat\_tree.xml & 0.040ms & 4 & 0.12ms & 100 \\ \hline
cluster\_crossbar.xml & 0.038ms & 4 & 0.12ms & 100 \\ \hline
cluster\_backbone.xml & 0.088ms & 4 & 0.12ms & 100 \\ \hline
cluster\_dragonfly.xml & 0.110ms & 4 & 0.45ms & 500 \\ \hline
cluster\_torus.xml & 0.145ms & 4 & 0.45ms & 500 \\ \hline
cluster\_crossbar.xml & 0.280ms & 4 & 0.90ms & 1,000 \\ \hline
cluster\_fat\_tree.xml & 0.310ms & 4 & 0.90ms & 1,000 \\ \hline
cluster\_fat\_tree.xml & 0.450ms & 8 & 2.40ms & 2,500 \\ \hline
cluster\_crossbar.xml & 0.420ms & 8 & 2.40ms & 2,500 \\ \hline
cluster\_dragonfly.xml & 0.580ms & 8 & 2.40ms & 2,500 \\ \hline
cluster\_torus.xml & 0.690ms & 8 & 2.40ms & 2,500 \\ \hline
cluster\_backbone.xml & 1.450ms & 8 & 2.40ms & 2,500 \\ \hline
cluster\_fat\_tree.xml & 1.150ms & 16 & 9.00ms & 10,000 \\ \hline
cluster\_crossbar.xml & 0.980ms & 16 & 9.00ms & 10,000 \\ \hline
cluster\_dragonfly.xml & 2.800ms & 16 & 9.00ms & 10,000 \\ \hline
cluster\_torus.xml & 3.450ms & 16 & 9.00ms & 10,000 \\ \hline
cluster\_backbone.xml & 7.200ms & 16 & 9.00ms & 10,000 \\ \hline
cluster\_fat\_tree.xml & 4.200ms & 32 & 45.0ms & 50,000 \\ \hline
cluster\_crossbar.xml & 3.900ms & 32 & 45.0ms & 50,000 \\ \hline
cluster\_dragonfly.xml & 6.800ms & 32 & 45.0ms & 50,000 \\ \hline
cluster\_torus.xml & 9.200ms & 32 & 45.0ms & 50,000 \\ \hline
cluster\_fat\_tree.xml & 12.50ms & 64 & 180.0ms & 200,000 \\ \hline
cluster\_crossbar.xml & 10.10ms & 64 & 180.0ms & 200,000 \\ \hline
cluster\_dragonfly.xml & 18.40ms & 64 & 180.0ms & 200,000 \\ \hline
cluster\_torus.xml & 24.50ms & 64 & 180.0ms & 200,000 \\ \hline
cluster\_backbone.xml & 65.00ms & 64 & 180.0ms & 200,000 \\ \hline
cluster\_fat\_tree.xml & 28.50ms & 128 & 450.0ms & 500,000 \\ \hline
cluster\_crossbar.xml & 21.20ms & 128 & 450.0ms & 500,000 \\ \hline
cluster\_dragonfly.xml & 42.60ms & 128 & 450.0ms & 500,000 \\ \hline
cluster\_torus.xml & 58.10ms & 128 & 450.0ms & 500,000 \\ \hline
cluster\_backbone.xml & 142.0ms & 128 & 450.0ms & 500,000 \\ \hline
cluster\_fat\_tree.xml & 52.40ms & 512 & 900.0ms & 1,000,000 \\ \hline
cluster\_crossbar.xml & 41.50ms & 512 & 900.0ms & 1,000,000 \\ \hline
cluster\_dragonfly.xml & 88.20ms & 1024 & 1800ms & 2,000,000 \\ \hline
cluster\_torus.xml & 195.0ms & 1024 & 1800ms & 2,000,000 \\ \hline
cluster\_backbone.xml & 580.0ms & 1024 & 1800ms & 2,000,000 \\ \hline
\end{longtable}

\end{document}