




#  What Is the Herd Effect?
(This defination is taked from google)

In a naive leader election system:

1. When a leader fails or disconnects,
2. ZooKeeper sends a notification to all nodes,
3. All nodes simultaneously try to become the next leader,
4. This results in a massive spike of requests hitting ZooKeeper at once.

This creates:

- High CPU usage  
- High network load  
- Performance degradation as the cluster grows  

This is known as the Herd Effect.

---

# How This small demo Solution Avoids the Herd Effect

I used **Ephemeral Sequential znodes**, a built-in ZooKeeper pattern for safe and efficient leader election.

### How it works:

1. Each node creates an **ephemeral sequential** znode under:
```

/election/node_

```

2. ZooKeeper automatically assigns each client a unique number:
```

node_0000001
node_0000002
node_0000003

```

3. The node with the smallest number is the leader.

4. Non-leader nodes do NOT watch the leader.  
Instead, each node watches **only the node directly before it** (its predecessor).

### Why this avoids the Herd Effect:

- Only one node wakes up when a failure happens  
- Only the node whose predecessor disappeared runs an election step  
- Zero thundering herd  
- ZooKeeper load stays small, even with hundreds or thousands of clients

This is the most scalable and recommended approach for leader election with ZooKeeper.

---

#  Project Structure

```

src/main/java/com/ds/LeaderElection/
│── App.java
│── LeaderElection.java
│── ZKConnection.java
launch.sh              (starts ZooKeeper ensemble)
pom.xml
README.md
conf/  --> contains configuration for launch.sh
````

---

#  Running the Project

### 1. Start ZooKeeper Ensemble

The project includes a `launch.sh` script that starts 3 ZooKeeper servers
defined in The configuration files.

Run:

```bash
./launch.sh
````

This boots ZooKeeper servers on ports:

* 2181
* 2182
* 2183

With corresponding quorum and election ports.

---

### 2. Run the leader election demo

Open multiple terminals, and from the project root, run:

```bash
mvn exec:java
```

Run it 2x, 3x, or more times to simulate multiple clients.

Each instance will:

* Connect to ZooKeeper
* Create an ephemeral sequential node
* Either become the leader
* Or watch its predecessor
* Automatically take over leadership when needed









```
