from concurrent import futures
import grpc
import add_pb2
import add_pb2_grpc

class AddServiceServicer(add_pb2_grpc.AddServiceServicer):
    def Add(self, request, context):
        result = request.a + request.b
        return add_pb2.AddResponse(result=result)

def serve():
    server = grpc.server(futures.ThreadPoolExecutor(max_workers=10))
    add_pb2_grpc.add_AddServiceServicer_to_server(AddServiceServicer(), server)
    server.add_insecure_port('[::]:50051')  # listen on port 50051
    print("Server started on port 50051...")
    server.start()
    server.wait_for_termination()

if __name__ == '__main__':
    serve()

