package org.ds;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.gson.Gson;
import org.ds.proto.Book;
import org.ds.proto.Publisher;
import org.ds.proto.Genre;

public class Main {
    public static void main(String[] args) throws InvalidProtocolBufferException {
        // Create Publisher
        Publisher publisher = Publisher.newBuilder()
                .setName("O'Reilly Media")
                .setCountry("USA")
                .setFoundedYear(1980)
                .build();

        // Create Book
        Book book = Book.newBuilder()
                .setTitle("Learning Java")
                .setAuthor("Patrick Niemeyer")
                .setIsbn("978-1492056270")
                .setYear(2020)
                .setGenre(Genre.TECHNOLOGY)
                .setPublisher(publisher)
                .build();

        byte[] protobufData = book.toByteArray();
        System.out.println("Protobuf serialized size: " + protobufData.length + " bytes");

        // Deserialize (decode) to verify
        Book decodedBook = Book.parseFrom(protobufData);
        System.out.println("Decoded Book (Protobuf):\n" + decodedBook);

        Gson gson = new Gson();

        // Convert Book to a plain Java object suitable for Gson
        // Protobuf-generated classes have getters, so Gson can serialize them directly
        String json = gson.toJson(book);
        byte[] jsonBytes = json.getBytes();
        System.out.println("\nJSON serialized size: " + jsonBytes.length + " bytes");
        System.out.println("JSON string:\n" + json);

        double ratio = (double) jsonBytes.length / protobufData.length;
        System.out.printf("\nJSON is %.2fx larger than Protobuf\n", ratio);
    }
}

