import grpc from "@grpc/grpc-js";
import protoLoader from "@grpc/proto-loader";

// Load the proto file
const packageDefinition = protoLoader.loadSync("./multiply.proto", {});
const multiplyProto = grpc.loadPackageDefinition(packageDefinition).multiplyservice;

// Create the service implementation
function multiply(call, callback) {
  const result = call.request.a * call.request.b;
  callback(null, { result });
}

// Start the gRPC server
function main() {
  const server = new grpc.Server();
  server.addService(multiplyProto.MultiplyService.service, { Multiply: multiply });
  const port = "50052";
  server.bindAsync(
    `0.0.0.0:${port}`,
    grpc.ServerCredentials.createInsecure(),
    () => {
      server.start();
      console.log(` gRPC Server running on port ${port}`);
    }
  );
}

main();
