package main

import (
	"context"
	"fmt"
	"log"
	"os"
	"strconv"
	"time"

	"google.golang.org/grpc"

	"goGRPC/addservicepb"
	"goGRPC/multiplyservicepb"
)

func main() {
	// Read optional command-line args (defaults to 5 and 7)
	a, b := 5.0, 7.0
	if len(os.Args) == 3 {
		if val, err := strconv.ParseFloat(os.Args[1], 64); err == nil {
			a = val
		}
		if val, err := strconv.ParseFloat(os.Args[2], 64); err == nil {
			b = val
		}
	}

	fmt.Printf("Using values: a=%.2f, b=%.2f\n", a, b)

	// === 1️⃣ Connect to Python AddService (port 50051)
	addConn, err := grpc.Dial("localhost:50051", grpc.WithInsecure())
	if err != nil {
		log.Fatalf("Could not connect to AddService: %v", err)
	}
	defer addConn.Close()

	addClient := addservicepb.NewAddServiceClient(addConn)
	addCtx, cancel := context.WithTimeout(context.Background(), 3*time.Second)
	defer cancel()

	addRes, err := addClient.Add(addCtx, &addservicepb.AddRequest{A: a, B: b})
	if err != nil {
		log.Fatalf(" Error calling AddService: %v", err)
	}
	fmt.Printf("Add result: %.2f\n", addRes.Result)

	// === 2️⃣ Connect to Node MultiplyService (port 50052)
	multConn, err := grpc.Dial("localhost:50052", grpc.WithInsecure())
	if err != nil {
		log.Fatalf(" Could not connect to MultiplyService: %v", err)
	}
	defer multConn.Close()

	multClient := multiplyservicepb.NewMultiplyServiceClient(multConn)
	multCtx, cancel2 := context.WithTimeout(context.Background(), 3*time.Second)
	defer cancel2()

	multRes, err := multClient.Multiply(multCtx, &multiplyservicepb.MultiplyRequest{A: a, B: b})
	if err != nil {
		log.Fatalf(" Error calling MultiplyService: %v", err)
	}
	fmt.Printf("Multiply result: %.2f\n", multRes.Result)
}
