from concurrent import futures
import grpc
import sqlite3
from datetime import datetime
import add_pb2
import add_pb2_grpc


def init_db():
    conn = sqlite3.connect("add_logs.db")
    cursor = conn.cursor()
    cursor.execute("""
        CREATE TABLE IF NOT EXISTS add_logs (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            a REAL,
            b REAL,
            result REAL,
            timestamp TEXT
        )
    """)
    conn.commit()
    conn.close()


class AddServiceServicer(add_pb2_grpc.AddServiceServicer):
    def Add(self, request, context):
        result = request.a + request.b

        # Log operation to SQLite
        try:
            conn = sqlite3.connect("add_logs.db")
            cursor = conn.cursor()
            cursor.execute(
                "INSERT INTO add_logs (a, b, result, timestamp) VALUES (?, ?, ?, ?)",
                (request.a, request.b, result, datetime.now().isoformat())
            )
            conn.commit()
            conn.close()
            print(f"Logged: {request.a} + {request.b} = {result}")
        except Exception as e:
            print(f"Database logging failed: {e}")

        return add_pb2.AddResponse(result=result)

    def StreamLogs(self, request, context):
        """Stream the most recent 'limit' add operations from the database."""
        limit = request.limit or 10  # Default: 10 logs
        conn = sqlite3.connect("add_logs.db")
        cursor = conn.cursor()
        cursor.execute(
            "SELECT a, b, result, timestamp FROM add_logs ORDER BY id DESC LIMIT ?",
            (limit,)
        )

        for row in cursor.fetchall():
            yield add_pb2.LogEntry(
                a=row[0],
                b=row[1],
                result=row[2],
                timestamp=row[3]
            )
        conn.close()


def serve():
    init_db()
    server = grpc.server(futures.ThreadPoolExecutor(max_workers=10))
  
    add_pb2_grpc.add_AddServiceServicer_to_server(AddServiceServicer(), server)
    server.add_insecure_port('[::]:50051')
    print("AddService gRPC server started on port 50051...")
    server.start()
    server.wait_for_termination()

if __name__ == '__main__':
    serve()

