import grpc from "@grpc/grpc-js";
import protoLoader from "@grpc/proto-loader";

const packageDefinition = protoLoader.loadSync("./multiply.proto", {});
const multiplyProto = grpc.loadPackageDefinition(packageDefinition).multiplyservice;

const client = new multiplyProto.MultiplyService(
  "localhost:50052",
  grpc.credentials.createInsecure()
);

client.Multiply({ a: 6, b: 7 }, (err, response) => {
  if (err) {
    console.error("Error:", err);
    return;
  }
  console.log(`Result: ${response.result}`);
});
