package main

import (
	"context"
	"fmt"
	"io"
	"log"
	"os"
	"strconv"
	"time"

	"google.golang.org/grpc"

	"goGRPC/addservicepb"
	"goGRPC/multiplyservicepb"
)

func main() {
	a, b := 5.0, 7.0
	mode := "calc" // default: perform Add/Multiply

	if len(os.Args) >= 2 {
		if os.Args[1] == "logs" {
			mode = "logs"
		} else if len(os.Args) == 3 {
			if val, err := strconv.ParseFloat(os.Args[1], 64); err == nil {
				a = val
			}
			if val, err := strconv.ParseFloat(os.Args[2], 64); err == nil {
				b = val
			}
		}
	}

	if mode == "calc" {
		runCalculations(a, b)
	} else {
		streamLogs()
	}
}

func runCalculations(a, b float64) {
	fmt.Printf("Performing Add/Multiply with a=%.2f, b=%.2f\n", a, b)

	// --- AddService ---
	addConn, err := grpc.Dial("localhost:50051", grpc.WithInsecure())
	if err != nil {
		log.Fatalf("Could not connect to AddService: %v", err)
	}
	defer addConn.Close()

	addClient := addservicepb.NewAddServiceClient(addConn)
	addCtx, cancel := context.WithTimeout(context.Background(), 3*time.Second)
	defer cancel()

	addRes, err := addClient.Add(addCtx, &addservicepb.AddRequest{A: a, B: b})
	if err != nil {
		log.Fatalf("Error calling AddService: %v", err)
	}
	fmt.Printf("Add result: %.2f\n", addRes.Result)


	multConn, err := grpc.Dial("localhost:50052", grpc.WithInsecure())
	if err != nil {
		log.Fatalf("Could not connect to MultiplyService: %v", err)
	}
	defer multConn.Close()

	multClient := multiplyservicepb.NewMultiplyServiceClient(multConn)
	multCtx, cancel2 := context.WithTimeout(context.Background(), 3*time.Second)
	defer cancel2()

	multRes, err := multClient.Multiply(multCtx, &multiplyservicepb.MultiplyRequest{A: a, B: b})
	if err != nil {
		log.Fatalf("Error calling MultiplyService: %v", err)
	}
	fmt.Printf("Multiply result: %.2f\n", multRes.Result)
}


func streamLogs() {
	
	addConn, err := grpc.Dial("localhost:50051", grpc.WithInsecure())
	if err != nil {
		log.Fatalf("Could not connect to AddService: %v", err)
	}
	defer addConn.Close()

	addClient := addservicepb.NewAddServiceClient(addConn)
	addStream, err := addClient.StreamLogs(context.Background(), &addservicepb.LogRequest{Limit: 5})
	if err != nil {
		log.Fatalf("Error starting AddService stream: %v", err)
	}

	fmt.Println("**** Recent Add Logs:")
	for {
		entry, err := addStream.Recv()
		if err == io.EOF {
			break
		}
		if err != nil {
			log.Fatalf("AddService stream error: %v", err)
		}
		fmt.Printf("a=%.2f, b=%.2f, result=%.2f, timestamp=%s\n", entry.A, entry.B, entry.Result, entry.Timestamp)
	}

	
	multConn, err := grpc.Dial("localhost:50052", grpc.WithInsecure())
	if err != nil {
		log.Fatalf("Could not connect to MultiplyService: %v", err)
	}
	defer multConn.Close()

	multClient := multiplyservicepb.NewMultiplyServiceClient(multConn)
	multStream, err := multClient.StreamLogs(context.Background(), &multiplyservicepb.LogRequest{Limit: 5})
	if err != nil {
		log.Fatalf("Error starting MultiplyService stream: %v", err)
	}

	fmt.Println("***** Recent Multiply Logs:")
	for {
		entry, err := multStream.Recv()
		if err == io.EOF {
			break
		}
		if err != nil {
			log.Fatalf("MultiplyService stream error: %v", err)
		}
		fmt.Printf("a=%.2f, b=%.2f, result=%.2f, timestamp=%s\n", entry.A, entry.B, entry.Result, entry.Timestamp)
	}
}

