# gRPC Distributed Computation
````markdown
This project demonstrates a distributed computation system using gRPC across three different languages:
- Python for the Add service  
- Node.js for the Multiply service  
- Go for the client

---

## Running the Add Server (Python)

1. Navigate to the Python service directory:

   ```bash
   cd pythonGRPC
````

2. Activate the virtual environment:

   ```bash
   source .bin/activate
   ```

3. Run the server:

   ```bash
   python3 server.py
   ```

---

## Running the Multiply Server (Node.js)

1. Navigate to the Node service directory:

   ```bash
   cd nodeGRPC
   ```

2. Start the server:

   ```bash
   node server.mjs
   ```

---

## Running the Client (Go)

1. Navigate to the Go client directory:

   ```bash
   cd goGRPC
   ```

2. To perform a calculation:

   ```bash
   go run main.go numberA numberB
   ```

   Example:

   ```bash
   go run main.go 9 9
   ```

3. To fetch logs from both servers:

   ```bash
   go run main.go logs
   ```

---

## Example Usage

```bash
# Run a new calculation
go run main.go 9 9

# Stream previous logs from Add and Multiply services
go run main.go logs
```

---

Make sure both servers are running before executing the Go client.

```
```

