// MyThreadExample.java

// Method 1: Extending the Thread class
class MyThread extends Thread {
    public void run() {
        for (int i = 1; i <= 5; i++) {
            System.out.println("Thread running: " + i);
            try {
                Thread.sleep(500); // sleep for 0.5 second
            } catch (InterruptedException e) {
                System.out.println("Thread interrupted");
            }
        }
    }
}

// Method 2: Implementing Runnable interface
class MyRunnable implements Runnable {
    public void run() {
        for (int i = 1; i <= 5; i++) {
            System.out.println("Runnable running: " + i);
            try {
                Thread.sleep(500);
            } catch (InterruptedException e) {
                System.out.println("Runnable interrupted");
            }
        }
    }
}

public class MyThreadExample {
    public static void main(String[] args) {
        // Create thread using Thread subclass
        MyThread t1 = new MyThread();

        // Create thread using Runnable interface
        Thread t2 = new Thread(new MyRunnable());

        // Start both threads
        t1.start();
        t2.start();

        System.out.println("Main thread finished starting others!");
    }
}

