using Microsoft.EntityFrameworkCore;
using BUSNOW.Models;

namespace BUSNOW.Data
{
    public class AppDbContext : DbContext
    {
        public AppDbContext(DbContextOptions<AppDbContext> options)
            : base(options) { }

        public DbSet<Passenger> Passengers { get; set; }
        public DbSet<Line> Lines { get; set; }
        public DbSet<Stop> Stops { get; set; }
      
        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            base.OnModelCreating(modelBuilder);

             modelBuilder.Entity<Passenger>()
        .HasOne<Line>()                  // No navigation property
        .WithMany(l => l.Passengers)
        .HasForeignKey(p => p.LineId)
        .IsRequired();

    // Stop -> Line
    modelBuilder.Entity<Stop>()
        .HasOne<Line>()                  // No navigation property
        .WithMany(l => l.Stops)
        .HasForeignKey(s => s.LineId)
        .IsRequired();
            
        }
    }
}
