import org.apache.zookeeper.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.Random;
import java.util.concurrent.locks.LockSupport;

public class Worker {
    private static final Logger logger = LoggerFactory.getLogger(Worker.class);

    private static final String ZK = "127.0.0.1:2181";
    private static final int TIMEOUT = 3000;
    private static final String WORKERS = "/workers";

    private static final float FAIL_RATE = 0.1f;

    private ZooKeeper zk;
    private final Random random = new Random();

    public void connectToZookeeper() throws IOException {
        zk = new ZooKeeper(ZK, TIMEOUT, e -> {});
    }

    public void work() throws Exception {
        String nodeId = System.getenv("NODE_ID");

        zk.create(
                WORKERS + "/worker-",
                nodeId.getBytes(),
                ZooDefs.Ids.OPEN_ACL_UNSAFE,
                CreateMode.EPHEMERAL_SEQUENTIAL
        );

        logger.info("Worker running on node {}", nodeId);

        while (true) {
            LockSupport.parkNanos(100_000_000);
            if (random.nextFloat() < FAIL_RATE) {
                throw new RuntimeException("Simulated failure");
            }
        }
    }
}
