import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application {
    private static final Logger logger = LoggerFactory.getLogger(Application.class);

    public static void main(String[] args) {
        logger.info("Starting worker...");

        try {
            Worker worker = new Worker();
            worker.connectToZookeeper();
            worker.work();
        } catch (Exception e) {
            logger.error("Worker crashed", e);
            System.exit(1);
        }
    }
}
