import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

public class Application {
    private static final Logger logger = LoggerFactory.getLogger(Application.class);

    public static void main(String[] args) throws IOException, KeeperException, InterruptedException {
        if (args.length < 2) {
            logger.error("Usage: java -jar autohealer.jar <number_of_workers> <path_to_worker_jar>");
            System.exit(1);
        }

        int numWorkers = Integer.parseInt(args[0]);
        String workerPath = args[1];

        Autohealer autohealer = new Autohealer(numWorkers, workerPath);
        autohealer.connectToZookeeper();
        autohealer.startWatchingWorkers();
        autohealer.run(); // blocks
    }
}
