/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Autohealer
implements Watcher {
    private static final Logger logger = LoggerFactory.getLogger(Autohealer.class);
    private static final String ZOOKEEPER_ADDRESS = "127.0.0.1:2181,127.0.0.1:2182,127.0.0.1:2183";
    private static final int SESSION_TIMEOUT = 3000;
    private static final String WORKERS_PATH = "/workers";
    private final String pathToWorkerJar;
    private final int numberOfWorkers;
    private ZooKeeper zooKeeper;
    private final List<String> physicalNodes = Arrays.asList("node1", "node2", "node3");

    public Autohealer(int numberOfWorkers, String pathToWorkerJar) {
        this.numberOfWorkers = numberOfWorkers;
        this.pathToWorkerJar = pathToWorkerJar;
    }

    public void connectToZookeeper() throws IOException {
        this.zooKeeper = new ZooKeeper(ZOOKEEPER_ADDRESS, 3000, this);
        logger.info("Connecting to ZooKeeper ensemble: {}", (Object)ZOOKEEPER_ADDRESS);
    }

    public void startWatchingWorkers() throws KeeperException, InterruptedException {
        if (this.zooKeeper.exists(WORKERS_PATH, false) == null) {
            this.zooKeeper.create(WORKERS_PATH, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            logger.info("Created parent znode: {}", (Object)WORKERS_PATH);
        }
        this.checkAndLaunchWorkers();
        this.zooKeeper.getChildren(WORKERS_PATH, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws InterruptedException {
        ZooKeeper zooKeeper = this.zooKeeper;
        synchronized (zooKeeper) {
            this.zooKeeper.wait();
        }
    }

    public void close() throws InterruptedException {
        this.zooKeeper.close();
        logger.info("ZooKeeper connection closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(WatchedEvent event) {
        if (event.getType() == Watcher.Event.EventType.None) {
            if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                logger.info("Successfully connected to ZooKeeper");
            } else {
                ZooKeeper zooKeeper = this.zooKeeper;
                synchronized (zooKeeper) {
                    logger.warn("Disconnected from ZooKeeper");
                    this.zooKeeper.notifyAll();
                }
            }
            return;
        }
        if (event.getType() == Watcher.Event.EventType.NodeChildrenChanged && event.getPath().equals(WORKERS_PATH)) {
            try {
                logger.info("Workers changed, checking cluster health...");
                this.checkAndLaunchWorkers();
            }
            catch (Exception e) {
                logger.error("Error checking/launching workers", e);
            }
        }
        try {
            this.zooKeeper.getChildren(WORKERS_PATH, this);
        }
        catch (Exception e) {
            logger.error("Failed to reset watch", e);
        }
    }

    private void checkAndLaunchWorkers() throws KeeperException, InterruptedException {
        List<String> children = this.zooKeeper.getChildren(WORKERS_PATH, false);
        int currentWorkers = children.size();
        int toLaunch = this.numberOfWorkers - currentWorkers;
        if (toLaunch > 0) {
            logger.info("Need to launch {} new worker(s)", (Object)toLaunch);
            for (int i = 0; i < toLaunch; ++i) {
                try {
                    String node = this.selectNodeForWorker(children);
                    this.startNewWorker(node);
                    continue;
                }
                catch (IOException e) {
                    logger.error("Failed to start new worker", e);
                }
            }
        } else {
            logger.debug("All workers are running, no action needed");
        }
    }

    private String selectNodeForWorker(List<String> currentWorkers) {
        int idx = currentWorkers.size() % this.physicalNodes.size();
        return this.physicalNodes.get(idx);
    }

    private void startNewWorker(String node) throws IOException {
        File file = new File(this.pathToWorkerJar);
        String command = String.format("ssh %s java -jar %s", node, file.getAbsolutePath());
        logger.info("Launching worker on {}: {}", (Object)node, (Object)command);
        Runtime.getRuntime().exec(command, null, file.getParentFile());
    }
}

