/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.List;
import java.util.Random;
import java.util.concurrent.locks.LockSupport;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Worker {
    private static final Logger logger = LoggerFactory.getLogger(Worker.class);
    private static final String ZOOKEEPER_ADDRESS = "127.0.0.1:2181";
    private static final int SESSION_TIMEOUT = 3000;
    private static final String AUTOHEALER_ZNODES_PATH = "/workers";
    private static final float CHANCE_TO_FAIL = 0.1f;
    private final Random random = new Random();
    private ZooKeeper zooKeeper;

    public void connectToZookeeper() throws IOException {
        this.zooKeeper = new ZooKeeper(ZOOKEEPER_ADDRESS, 3000, event -> {});
        logger.info("Connected to ZooKeeper at {}", (Object)ZOOKEEPER_ADDRESS);
    }

    public void work() throws KeeperException, InterruptedException {
        this.addChildZnode();
        logger.info("Worker node created, starting work loop...");
        do {
            logger.debug("Working...");
            LockSupport.parkNanos(100000000L);
        } while (!(this.random.nextFloat() < 0.1f));
        logger.error("Critical error happened, exiting...");
        throw new RuntimeException("Worker simulated failure");
    }

    private void addChildZnode() throws KeeperException, InterruptedException {
        this.zooKeeper.create("/workers/worker_", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        logger.info("Registered ephemeral znode under {}", (Object)AUTOHEALER_ZNODES_PATH);
    }
}

