import MenuIcon from "@/src/components/assets/custom-ant-icons/menu-icon";
import React from "react";
import UsersIcon from "@/src/components/assets/custom-ant-icons/sidebar/users-icon";
import { ExclamationOutlined, FontColorsOutlined } from "@ant-design/icons";
interface Props {
  statSubtitle: string;
  statTitle: string;
  statArrow: any;
  statPercent: string;
  statPercentColor: string;
  statDescripiron: any;
  statIconName: any;
  statIconColor: string;
}

export default function CardStats({
  statSubtitle,
  statTitle,
  statArrow,
  statPercent,
  statPercentColor,
  statDescripiron,
  statIconName,
  statIconColor,
}: Props) {
  return (
    <>
      <div className="relative flex flex-col min-w-0 break-words bg-white rounded mb-6 xl:mb-0 shadow-lg">
        <div className="flex-auto p-4">
          <div className="flex flex-wrap">
            <div className="relative w-full pr-4 max-w-full flex-grow flex-1">
              <h5 className="text-blueGray-400 uppercase font-bold text-xs">
                {statSubtitle}
              </h5>
              <span className="font-semibold text-xl text-blueGray-700">
                {statTitle}
              </span>
            </div>
            <div className="relative w-auto pl-4 flex-initial">
              <div
                className={
                  "text-white p-3 text-center inline-flex items-center justify-center w-12 h-12 shadow-lg rounded-full " +
                  statIconColor
                }
              >
                {statIconName == "group" ? (
                  <UsersIcon style={{ fontSize: "19px", color: "#fff" }} />
                ) : statIconName == "admin" ? (
                  <FontColorsOutlined
                    style={{ fontSize: "19px", color: "#000f24" }}
                  />
                ) : statIconName == "traps" ? (
                  <ExclamationOutlined
                  style={{ fontSize: "30px", color: "#fff" }}
                  className={"ExclamationCircleOutlined "}
                />
                ): null
                }
                {/* <i className={statIconName}></i> */}
              </div>
            </div>
          </div>
          <p className="text-sm text-blueGray-400 mt-4">
            <span className={statPercentColor + " mr-2"}>
              <i
                className={
                  statArrow === "up"
                    ? "fas fa-arrow-up"
                    : statArrow === "down"
                    ? "fas fa-arrow-down"
                    : ""
                }
              ></i>{" "}
              {statPercent}%
            </span>
            <span className="whitespace-nowrap">{statDescripiron}</span>
          </p>
        </div>
      </div>
    </>
  );
}

CardStats.defaultProps = {
  statSubtitle: "Traffic",
  statTitle: "350,897",
  statArrow: "up",
  statPercent: "3.48",
  statPercentColor: "text-emerald-500",
  statDescripiron: "Since last month",
  statIconName: <MenuIcon />,
  statIconColor: "bg-red-500",
};
