package task;

// ترث من TaskImpl بدلاً من تنفيذ Task
public class TaskSleep extends TaskImpl {

    @Override
    public void execute() {
        long duration = 0;

        try {
            // محاولة قراءة المدخلات كزمن (Input reading logic)
            duration = Long.parseLong(this.input);
        } catch (NumberFormatException e) {
            this.result = "Error: Invalid sleep duration provided.";
            return;
        }

        try {
            // منطق التأخير (Sleep logic)
            Thread.sleep(duration);
            this.result = "Slept successfully for " + duration + "ms.";
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.result = "Sleep task was interrupted.";
        }
    }

    // لا حاجة لإعادة تعريف setInput, setExecutedTime, getResult, toString!
    // جميعها موروثة من TaskImpl.
}