package com.weather.monitoring.grpc;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * 2. Weather Analytics Service (Python) - The central server
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.60.0)",
    comments = "Source: weather.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class WeatherAnalyticsServiceGrpc {

  private WeatherAnalyticsServiceGrpc() {}

  public static final java.lang.String SERVICE_NAME = "weather_system.WeatherAnalyticsService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.weather.monitoring.grpc.Weather.WeatherData,
      com.weather.monitoring.grpc.Weather.WeatherStats> getStreamWeatherDataMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "StreamWeatherData",
      requestType = com.weather.monitoring.grpc.Weather.WeatherData.class,
      responseType = com.weather.monitoring.grpc.Weather.WeatherStats.class,
      methodType = io.grpc.MethodDescriptor.MethodType.CLIENT_STREAMING)
  public static io.grpc.MethodDescriptor<com.weather.monitoring.grpc.Weather.WeatherData,
      com.weather.monitoring.grpc.Weather.WeatherStats> getStreamWeatherDataMethod() {
    io.grpc.MethodDescriptor<com.weather.monitoring.grpc.Weather.WeatherData, com.weather.monitoring.grpc.Weather.WeatherStats> getStreamWeatherDataMethod;
    if ((getStreamWeatherDataMethod = WeatherAnalyticsServiceGrpc.getStreamWeatherDataMethod) == null) {
      synchronized (WeatherAnalyticsServiceGrpc.class) {
        if ((getStreamWeatherDataMethod = WeatherAnalyticsServiceGrpc.getStreamWeatherDataMethod) == null) {
          WeatherAnalyticsServiceGrpc.getStreamWeatherDataMethod = getStreamWeatherDataMethod =
              io.grpc.MethodDescriptor.<com.weather.monitoring.grpc.Weather.WeatherData, com.weather.monitoring.grpc.Weather.WeatherStats>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.CLIENT_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "StreamWeatherData"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.weather.monitoring.grpc.Weather.WeatherData.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.weather.monitoring.grpc.Weather.WeatherStats.getDefaultInstance()))
              .setSchemaDescriptor(new WeatherAnalyticsServiceMethodDescriptorSupplier("StreamWeatherData"))
              .build();
        }
      }
    }
    return getStreamWeatherDataMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.weather.monitoring.grpc.Weather.Empty,
      com.weather.monitoring.grpc.Weather.WeatherStats> getStreamAnalyticsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "StreamAnalytics",
      requestType = com.weather.monitoring.grpc.Weather.Empty.class,
      responseType = com.weather.monitoring.grpc.Weather.WeatherStats.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<com.weather.monitoring.grpc.Weather.Empty,
      com.weather.monitoring.grpc.Weather.WeatherStats> getStreamAnalyticsMethod() {
    io.grpc.MethodDescriptor<com.weather.monitoring.grpc.Weather.Empty, com.weather.monitoring.grpc.Weather.WeatherStats> getStreamAnalyticsMethod;
    if ((getStreamAnalyticsMethod = WeatherAnalyticsServiceGrpc.getStreamAnalyticsMethod) == null) {
      synchronized (WeatherAnalyticsServiceGrpc.class) {
        if ((getStreamAnalyticsMethod = WeatherAnalyticsServiceGrpc.getStreamAnalyticsMethod) == null) {
          WeatherAnalyticsServiceGrpc.getStreamAnalyticsMethod = getStreamAnalyticsMethod =
              io.grpc.MethodDescriptor.<com.weather.monitoring.grpc.Weather.Empty, com.weather.monitoring.grpc.Weather.WeatherStats>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "StreamAnalytics"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.weather.monitoring.grpc.Weather.Empty.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.weather.monitoring.grpc.Weather.WeatherStats.getDefaultInstance()))
              .setSchemaDescriptor(new WeatherAnalyticsServiceMethodDescriptorSupplier("StreamAnalytics"))
              .build();
        }
      }
    }
    return getStreamAnalyticsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.weather.monitoring.grpc.Weather.Empty,
      com.weather.monitoring.grpc.Weather.WeatherStats> getGetLastReportMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetLastReport",
      requestType = com.weather.monitoring.grpc.Weather.Empty.class,
      responseType = com.weather.monitoring.grpc.Weather.WeatherStats.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.weather.monitoring.grpc.Weather.Empty,
      com.weather.monitoring.grpc.Weather.WeatherStats> getGetLastReportMethod() {
    io.grpc.MethodDescriptor<com.weather.monitoring.grpc.Weather.Empty, com.weather.monitoring.grpc.Weather.WeatherStats> getGetLastReportMethod;
    if ((getGetLastReportMethod = WeatherAnalyticsServiceGrpc.getGetLastReportMethod) == null) {
      synchronized (WeatherAnalyticsServiceGrpc.class) {
        if ((getGetLastReportMethod = WeatherAnalyticsServiceGrpc.getGetLastReportMethod) == null) {
          WeatherAnalyticsServiceGrpc.getGetLastReportMethod = getGetLastReportMethod =
              io.grpc.MethodDescriptor.<com.weather.monitoring.grpc.Weather.Empty, com.weather.monitoring.grpc.Weather.WeatherStats>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetLastReport"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.weather.monitoring.grpc.Weather.Empty.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.weather.monitoring.grpc.Weather.WeatherStats.getDefaultInstance()))
              .setSchemaDescriptor(new WeatherAnalyticsServiceMethodDescriptorSupplier("GetLastReport"))
              .build();
        }
      }
    }
    return getGetLastReportMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.weather.monitoring.grpc.Weather.AlertMessage,
      com.weather.monitoring.grpc.Weather.WeatherData> getControlSensorMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ControlSensor",
      requestType = com.weather.monitoring.grpc.Weather.AlertMessage.class,
      responseType = com.weather.monitoring.grpc.Weather.WeatherData.class,
      methodType = io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
  public static io.grpc.MethodDescriptor<com.weather.monitoring.grpc.Weather.AlertMessage,
      com.weather.monitoring.grpc.Weather.WeatherData> getControlSensorMethod() {
    io.grpc.MethodDescriptor<com.weather.monitoring.grpc.Weather.AlertMessage, com.weather.monitoring.grpc.Weather.WeatherData> getControlSensorMethod;
    if ((getControlSensorMethod = WeatherAnalyticsServiceGrpc.getControlSensorMethod) == null) {
      synchronized (WeatherAnalyticsServiceGrpc.class) {
        if ((getControlSensorMethod = WeatherAnalyticsServiceGrpc.getControlSensorMethod) == null) {
          WeatherAnalyticsServiceGrpc.getControlSensorMethod = getControlSensorMethod =
              io.grpc.MethodDescriptor.<com.weather.monitoring.grpc.Weather.AlertMessage, com.weather.monitoring.grpc.Weather.WeatherData>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ControlSensor"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.weather.monitoring.grpc.Weather.AlertMessage.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.weather.monitoring.grpc.Weather.WeatherData.getDefaultInstance()))
              .setSchemaDescriptor(new WeatherAnalyticsServiceMethodDescriptorSupplier("ControlSensor"))
              .build();
        }
      }
    }
    return getControlSensorMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static WeatherAnalyticsServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<WeatherAnalyticsServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<WeatherAnalyticsServiceStub>() {
        @java.lang.Override
        public WeatherAnalyticsServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new WeatherAnalyticsServiceStub(channel, callOptions);
        }
      };
    return WeatherAnalyticsServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static WeatherAnalyticsServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<WeatherAnalyticsServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<WeatherAnalyticsServiceBlockingStub>() {
        @java.lang.Override
        public WeatherAnalyticsServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new WeatherAnalyticsServiceBlockingStub(channel, callOptions);
        }
      };
    return WeatherAnalyticsServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static WeatherAnalyticsServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<WeatherAnalyticsServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<WeatherAnalyticsServiceFutureStub>() {
        @java.lang.Override
        public WeatherAnalyticsServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new WeatherAnalyticsServiceFutureStub(channel, callOptions);
        }
      };
    return WeatherAnalyticsServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * 2. Weather Analytics Service (Python) - The central server
   * </pre>
   */
  public interface AsyncService {

    /**
     * <pre>
     * A. Client Streaming (Required: Receive from Sensor)
     * Sensor streams data; the server (Analytics) returns the final stats.
     * Auth note: Token validation will use gRPC Metadata, not this message field.
     * </pre>
     */
    default io.grpc.stub.StreamObserver<com.weather.monitoring.grpc.Weather.WeatherData> streamWeatherData(
        io.grpc.stub.StreamObserver<com.weather.monitoring.grpc.Weather.WeatherStats> responseObserver) {
      return io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall(getStreamWeatherDataMethod(), responseObserver);
    }

    /**
     * <pre>
     * B. Server Streaming (Required: Send to Dashboard)
     * Dashboard requests (with Empty) a continuous stream of reports.
     * </pre>
     */
    default void streamAnalytics(com.weather.monitoring.grpc.Weather.Empty request,
        io.grpc.stub.StreamObserver<com.weather.monitoring.grpc.Weather.WeatherStats> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getStreamAnalyticsMethod(), responseObserver);
    }

    /**
     * <pre>
     * C. Unary RPC (Optional Requirement: Retrieve last report)
     * Dashboard manually requests the last stored stats.
     * </pre>
     */
    default void getLastReport(com.weather.monitoring.grpc.Weather.Empty request,
        io.grpc.stub.StreamObserver<com.weather.monitoring.grpc.Weather.WeatherStats> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetLastReportMethod(), responseObserver);
    }

    /**
     * <pre>
     * D. Bidirectional Streaming (Academic addition)
     * Allows the server to send immediate alerts and potentially control the sensor.
     * </pre>
     */
    default io.grpc.stub.StreamObserver<com.weather.monitoring.grpc.Weather.AlertMessage> controlSensor(
        io.grpc.stub.StreamObserver<com.weather.monitoring.grpc.Weather.WeatherData> responseObserver) {
      return io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall(getControlSensorMethod(), responseObserver);
    }
  }

  /**
   * Base class for the server implementation of the service WeatherAnalyticsService.
   * <pre>
   * 2. Weather Analytics Service (Python) - The central server
   * </pre>
   */
  public static abstract class WeatherAnalyticsServiceImplBase
      implements io.grpc.BindableService, AsyncService {

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return WeatherAnalyticsServiceGrpc.bindService(this);
    }
  }

  /**
   * A stub to allow clients to do asynchronous rpc calls to service WeatherAnalyticsService.
   * <pre>
   * 2. Weather Analytics Service (Python) - The central server
   * </pre>
   */
  public static final class WeatherAnalyticsServiceStub
      extends io.grpc.stub.AbstractAsyncStub<WeatherAnalyticsServiceStub> {
    private WeatherAnalyticsServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected WeatherAnalyticsServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new WeatherAnalyticsServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * A. Client Streaming (Required: Receive from Sensor)
     * Sensor streams data; the server (Analytics) returns the final stats.
     * Auth note: Token validation will use gRPC Metadata, not this message field.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<com.weather.monitoring.grpc.Weather.WeatherData> streamWeatherData(
        io.grpc.stub.StreamObserver<com.weather.monitoring.grpc.Weather.WeatherStats> responseObserver) {
      return io.grpc.stub.ClientCalls.asyncClientStreamingCall(
          getChannel().newCall(getStreamWeatherDataMethod(), getCallOptions()), responseObserver);
    }

    /**
     * <pre>
     * B. Server Streaming (Required: Send to Dashboard)
     * Dashboard requests (with Empty) a continuous stream of reports.
     * </pre>
     */
    public void streamAnalytics(com.weather.monitoring.grpc.Weather.Empty request,
        io.grpc.stub.StreamObserver<com.weather.monitoring.grpc.Weather.WeatherStats> responseObserver) {
      io.grpc.stub.ClientCalls.asyncServerStreamingCall(
          getChannel().newCall(getStreamAnalyticsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * C. Unary RPC (Optional Requirement: Retrieve last report)
     * Dashboard manually requests the last stored stats.
     * </pre>
     */
    public void getLastReport(com.weather.monitoring.grpc.Weather.Empty request,
        io.grpc.stub.StreamObserver<com.weather.monitoring.grpc.Weather.WeatherStats> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetLastReportMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * D. Bidirectional Streaming (Academic addition)
     * Allows the server to send immediate alerts and potentially control the sensor.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<com.weather.monitoring.grpc.Weather.AlertMessage> controlSensor(
        io.grpc.stub.StreamObserver<com.weather.monitoring.grpc.Weather.WeatherData> responseObserver) {
      return io.grpc.stub.ClientCalls.asyncBidiStreamingCall(
          getChannel().newCall(getControlSensorMethod(), getCallOptions()), responseObserver);
    }
  }

  /**
   * A stub to allow clients to do synchronous rpc calls to service WeatherAnalyticsService.
   * <pre>
   * 2. Weather Analytics Service (Python) - The central server
   * </pre>
   */
  public static final class WeatherAnalyticsServiceBlockingStub
      extends io.grpc.stub.AbstractBlockingStub<WeatherAnalyticsServiceBlockingStub> {
    private WeatherAnalyticsServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected WeatherAnalyticsServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new WeatherAnalyticsServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * B. Server Streaming (Required: Send to Dashboard)
     * Dashboard requests (with Empty) a continuous stream of reports.
     * </pre>
     */
    public java.util.Iterator<com.weather.monitoring.grpc.Weather.WeatherStats> streamAnalytics(
        com.weather.monitoring.grpc.Weather.Empty request) {
      return io.grpc.stub.ClientCalls.blockingServerStreamingCall(
          getChannel(), getStreamAnalyticsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * C. Unary RPC (Optional Requirement: Retrieve last report)
     * Dashboard manually requests the last stored stats.
     * </pre>
     */
    public com.weather.monitoring.grpc.Weather.WeatherStats getLastReport(com.weather.monitoring.grpc.Weather.Empty request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetLastReportMethod(), getCallOptions(), request);
    }
  }

  /**
   * A stub to allow clients to do ListenableFuture-style rpc calls to service WeatherAnalyticsService.
   * <pre>
   * 2. Weather Analytics Service (Python) - The central server
   * </pre>
   */
  public static final class WeatherAnalyticsServiceFutureStub
      extends io.grpc.stub.AbstractFutureStub<WeatherAnalyticsServiceFutureStub> {
    private WeatherAnalyticsServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected WeatherAnalyticsServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new WeatherAnalyticsServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * C. Unary RPC (Optional Requirement: Retrieve last report)
     * Dashboard manually requests the last stored stats.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.weather.monitoring.grpc.Weather.WeatherStats> getLastReport(
        com.weather.monitoring.grpc.Weather.Empty request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetLastReportMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_STREAM_ANALYTICS = 0;
  private static final int METHODID_GET_LAST_REPORT = 1;
  private static final int METHODID_STREAM_WEATHER_DATA = 2;
  private static final int METHODID_CONTROL_SENSOR = 3;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final AsyncService serviceImpl;
    private final int methodId;

    MethodHandlers(AsyncService serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_STREAM_ANALYTICS:
          serviceImpl.streamAnalytics((com.weather.monitoring.grpc.Weather.Empty) request,
              (io.grpc.stub.StreamObserver<com.weather.monitoring.grpc.Weather.WeatherStats>) responseObserver);
          break;
        case METHODID_GET_LAST_REPORT:
          serviceImpl.getLastReport((com.weather.monitoring.grpc.Weather.Empty) request,
              (io.grpc.stub.StreamObserver<com.weather.monitoring.grpc.Weather.WeatherStats>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_STREAM_WEATHER_DATA:
          return (io.grpc.stub.StreamObserver<Req>) serviceImpl.streamWeatherData(
              (io.grpc.stub.StreamObserver<com.weather.monitoring.grpc.Weather.WeatherStats>) responseObserver);
        case METHODID_CONTROL_SENSOR:
          return (io.grpc.stub.StreamObserver<Req>) serviceImpl.controlSensor(
              (io.grpc.stub.StreamObserver<com.weather.monitoring.grpc.Weather.WeatherData>) responseObserver);
        default:
          throw new AssertionError();
      }
    }
  }

  public static final io.grpc.ServerServiceDefinition bindService(AsyncService service) {
    return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
        .addMethod(
          getStreamWeatherDataMethod(),
          io.grpc.stub.ServerCalls.asyncClientStreamingCall(
            new MethodHandlers<
              com.weather.monitoring.grpc.Weather.WeatherData,
              com.weather.monitoring.grpc.Weather.WeatherStats>(
                service, METHODID_STREAM_WEATHER_DATA)))
        .addMethod(
          getStreamAnalyticsMethod(),
          io.grpc.stub.ServerCalls.asyncServerStreamingCall(
            new MethodHandlers<
              com.weather.monitoring.grpc.Weather.Empty,
              com.weather.monitoring.grpc.Weather.WeatherStats>(
                service, METHODID_STREAM_ANALYTICS)))
        .addMethod(
          getGetLastReportMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              com.weather.monitoring.grpc.Weather.Empty,
              com.weather.monitoring.grpc.Weather.WeatherStats>(
                service, METHODID_GET_LAST_REPORT)))
        .addMethod(
          getControlSensorMethod(),
          io.grpc.stub.ServerCalls.asyncBidiStreamingCall(
            new MethodHandlers<
              com.weather.monitoring.grpc.Weather.AlertMessage,
              com.weather.monitoring.grpc.Weather.WeatherData>(
                service, METHODID_CONTROL_SENSOR)))
        .build();
  }

  private static abstract class WeatherAnalyticsServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    WeatherAnalyticsServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.weather.monitoring.grpc.Weather.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("WeatherAnalyticsService");
    }
  }

  private static final class WeatherAnalyticsServiceFileDescriptorSupplier
      extends WeatherAnalyticsServiceBaseDescriptorSupplier {
    WeatherAnalyticsServiceFileDescriptorSupplier() {}
  }

  private static final class WeatherAnalyticsServiceMethodDescriptorSupplier
      extends WeatherAnalyticsServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final java.lang.String methodName;

    WeatherAnalyticsServiceMethodDescriptorSupplier(java.lang.String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (WeatherAnalyticsServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new WeatherAnalyticsServiceFileDescriptorSupplier())
              .addMethod(getStreamWeatherDataMethod())
              .addMethod(getStreamAnalyticsMethod())
              .addMethod(getGetLastReportMethod())
              .addMethod(getControlSensorMethod())
              .build();
        }
      }
    }
    return result;
  }
}
