/*
 * Decompiled with CFR 0.152.
 */
package com.weather.monitoring.grpc;

import com.weather.monitoring.grpc.Weather;
import com.weather.monitoring.grpc.WeatherAnalyticsServiceGrpc;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class DashboardClient {
    private final ManagedChannel channel;
    private final WeatherAnalyticsServiceGrpc.WeatherAnalyticsServiceBlockingStub blockingStub;
    private final WeatherAnalyticsServiceGrpc.WeatherAnalyticsServiceStub asyncStub;
    private static final String ANALYTICS_ADDRESS = "localhost:50051";

    public DashboardClient(String host, int port) {
        this.channel = ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build();
        this.blockingStub = WeatherAnalyticsServiceGrpc.newBlockingStub((Channel)this.channel);
        this.asyncStub = WeatherAnalyticsServiceGrpc.newStub((Channel)this.channel);
    }

    public void shutdown() throws InterruptedException {
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }

    public void getManualReport() {
        System.out.println("\n--- \u064b\u06ba\u201d\u00b5 Requesting Manual Report (Unary RPC) ---");
        try {
            Weather.Empty request = Weather.Empty.newBuilder().build();
            Weather.WeatherStats stats = this.blockingStub.getLastReport(request);
            String reportTime = new SimpleDateFormat("HH:mm:ss").format(new Date(stats.getReportTime() * 1000L));
            System.out.println("\u00e2\u0153\u2026 Last Stored Report (at " + reportTime + "):");
            System.out.printf("   > Avg Temp: %.2f C\n", stats.getAvgTemperature());
            System.out.printf("   > Avg Humidity: %.2f %%\n", stats.getAvgHumidity());
            System.out.printf("   > Avg Pressure: %.2f hPa\n", stats.getAvgPressure());
        }
        catch (Exception e) {
            Status status = Status.fromThrowable((Throwable)e);
            if (status.getCode() == Status.Code.NOT_FOUND) {
                System.err.println("\u00e2\u200c\u0152 Error: No reports currently stored in DB. Status: " + status.getDescription());
            }
            System.err.println("\u00e2\u200c\u0152 Error requesting manual report. Details: " + status.getDescription());
        }
    }

    public void streamAnalytics() {
        System.out.println("\n--- \u064b\u06ba\u06ba\u00a2 Subscribing to Continuous Analysis Stream (Server Streaming) ---");
        Weather.Empty request = Weather.Empty.newBuilder().build();
        this.asyncStub.streamAnalytics(request, new StreamObserver<Weather.WeatherStats>(){

            public void onNext(Weather.WeatherStats stats) {
                String reportTime = new SimpleDateFormat("HH:mm:ss").format(new Date(stats.getReportTime() * 1000L));
                System.out.printf("\n[%s] Updated Analysis Report -----------------\n", reportTime);
                System.out.printf("  \u064b\u06ba\u0152\u060c\u00ef\u00b8\u0688 Avg Temp: %.2f C\n", stats.getAvgTemperature());
                System.out.printf("  \u064b\u06ba\u2019\u00a7 Avg Humidity: %.2f %%\n", stats.getAvgHumidity());
                System.out.printf("  \u064b\u06ba\u2019\u00a8 Avg Pressure: %.2f hPa\n", stats.getAvgPressure());
            }

            public void onError(Throwable t) {
                Status status = Status.fromThrowable((Throwable)t);
                System.err.println("\u00e2\u200c\u0152 Stream Error from server. Details: " + status.getDescription());
            }

            public void onCompleted() {
                System.out.println("--- \u064b\u06ba\u203a\u2018 Analysis Stream Completed ---");
            }
        });
    }

    public static void main(String[] args) throws InterruptedException {
        DashboardClient client = new DashboardClient("localhost", 50051);
        try {
            client.getManualReport();
            client.streamAnalytics();
            Thread.sleep(Long.MAX_VALUE);
        }
        finally {
            client.shutdown();
        }
    }
}

