🌐 Distributed Weather Monitoring System (Polyglot gRPC)
This repository contains a robust, multi-language distributed system designed for real-time weather data monitoring and analysis.
The system is built around the high-performance gRPC framework
utilizing three different programming languages that communicate seamlessly via Protocol Buffers.

🌟 Key Features
Multilingual Integration: Seamless communication between Go (Client), Python (Server), and Java (Client).

Secure Connection: Metadata Authentication implemented in the Python server validates the Go client's API token.

Error-Based Alerting: Server (Python) terminates the client stream with a gRPC Status Code (RESOURCE_EXHAUSTED) upon detecting extreme temperature thresholds.

RPC Types: Utilizes Client Streaming, Server Streaming, and Unary RPC.




Component	      Language        	Role                             	Core RPC Type                                         	Key Protocol Feature
Sensor Client    	Go	           Data Generation & Stream           Sender	Client Streaming                          	Sends Metadata (Authorization Token).
Analytics Service	Python  	Central Server & Processor                	Server Streaming	                                           Validates Metadata; Sends Status Codes for alerts.
Dashboard Client	Java     	Data Consumer & Reporter	              Server Streaming + Unary                                     	Subscribes to live feed; Requests last report from SQLite.


🛠️ Installation & SetupPrerequisitesEnsure the following tools are installed and accessible via your system's PATH

:Protocol Buffers (protoc)
Go (v1.20+)Python (v3.9+) with grpcio and grpcio-tools
.Java (JDK 17+)A
pache Maven (v3.8+)StepsGenerate Stubs for Go and JavaNote:
This is assumed to be handled by running mvn clean install inside dashboard_java and running the protoc command inside sensor_go.
SystemYou must run the services in the correct sequence in three separate terminal windows

.Step 1: Start the Analytics Server (Python)Terminal 1Location: analytics_pythonCommand:python -m analytics_python.analytics_server
Step 2: Start the Dashboard Client (Java)The Java client connects and subscribes immediately.
Terminal 2Location: dashboard_javaAction:Run the DashboardClient.main() method directly from IntelliJ IDEA
(using the green Run button next to the main function).Step 3: Start the Sensor Client (Go)This client sends data,
triggers the tests, and demonstrates the alerts.Terminal 3Location: sensor_goCommand:go run sensor_client.goExpected:
Go client logs successful alert/auth tests. Java Console starts displaying Updated Analysis Report stream data

