package org.example;
import java.util.*;
import java.util.concurrent.*;

class MultipleConsumers implements Runnable {
    private final BlockingQueue<String> inputQueue;

    private final BlockingQueue<List<String>> outputQueue;
    private final String eofSignal;


    public MultipleConsumers(BlockingQueue<String> inputQueue,
                             BlockingQueue<List<String>> outputQueue,
                             String eofSignal) {
        this.inputQueue = inputQueue;
        this.outputQueue = outputQueue;
        this.eofSignal = eofSignal;
    }

    // Simualion of stemming
    private String performStemming(String word) {

        if (word.length() > 3) {
            if (word.endsWith("ing")) {
                return word.substring(0, word.length() - 3);
            }
            if (word.endsWith("s")) {
                return word.substring(0, word.length() - 1);
            }
            if (word.endsWith("ed")) {
                return word.substring(0, word.length() - 2);
            }
        }
        return word;
    }

    @Override
    public void run() {
        System.out.println("Prosser " + Thread.currentThread().getName() + " The stemming process has begun");


        List<String> localStems = new ArrayList<>();

        try {
            while (true) {
                String line = inputQueue.take();

                if (line.equals(eofSignal)) {

                    outputQueue.put(localStems);
                    inputQueue.put(eofSignal);
                    break;
                }

                String[] words = line.toLowerCase().replaceAll("[^a-zA-Z\\s]", "").split("\\s+");
                for (String word : words) {
                    if (!word.isEmpty()) {
                        String stem = performStemming(word);

                        localStems.add(stem);
                    }
                }
            }
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        } catch (Exception e) {
            System.err.println("fault in prosseing: " + e.getMessage());
        } finally {
            System.out.println("Prosser " + Thread.currentThread().getName() + " The stemming process has finished.");
        }
    }
}