package org.example;
import java.io.*;
import java.util.*;
import java.util.concurrent.*;

class SingleConsumerWriter implements Runnable {
    private final String outputPath;

    private final BlockingQueue<List<String>> inputQueue;
    private final int numExpectedResults;

    public SingleConsumerWriter(String outputPath, BlockingQueue<List<String>> inputQueue, int numExpectedResults) {
        this.outputPath = outputPath;
        this.inputQueue = inputQueue;
        this.numExpectedResults = numExpectedResults;
    }

    @Override
    public void run() {
        System.out.println("The writing consumer began collecting and writing the roots. .");

        List<String> finalStems = new ArrayList<>();
        int resultsReceived = 0;

        try {
            while (resultsReceived < numExpectedResults) {

                List<String> partialStems = inputQueue.take();


                finalStems.addAll(partialStems);
                resultsReceived++;
            }


            try (PrintWriter writer = new PrintWriter(new FileWriter(outputPath))) {
                writer.println("List of extracted roots");

                finalStems.stream()
                        .sorted()
                        .forEach(writer::println);
            }
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        } catch (IOException e) {
            System.err.println("Error writing the output file: " + e.getMessage());
        } finally {
            System.out.println(" The writing consumer has completed the merging and writing process.");
        }
    }
}