package org.example;

import java.io.*;
import java.util.concurrent.*;

class Producer implements Runnable {
    private final String filePath;
    private final BlockingQueue<String> outputQueue;
    private final String eofSignal;

    public Producer(String filePath, BlockingQueue<String> outputQueue, String eofSignal) {
        this.filePath = filePath;
        this.outputQueue = outputQueue;
        this.eofSignal = eofSignal;
    }

    @Override
    public void run() {
        System.out.println("➡️ Producer started reading from file: " + filePath);
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath))) {
            String line;
            while ((line = reader.readLine()) != null) {
                // Placing the line in the Blocking Queue (may block if the queue is full)
                outputQueue.put(line);
            }
        } catch (IOException e) {
            System.err.println("Error reading input file: " + e.getMessage());
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        } finally {
            // Sending the End-Of-File (EOF) signal to all consumers
            try {

                // Send the signal 'N' times, where N is the number of consumers.
                // This ensures every consumer receives the signal to stop.
                for (int i = 0; i < Stemming.NUM_CONSUMERS; i++) {
                    outputQueue.put(eofSignal);
                }
                System.out.println(" Producer finished sending all lines and EOF signal.");
            } catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}
