# Producer_Consume

Producer/Consumer Word Stemming Project
This project implements a concurrent Producer/Consumer model in Java for processing large 
text files. Its primary goal is to accelerate the Word Stemming process by distributing the 
workload across multiple threads and efficiently separating I/O operations from in-memory 
processing.
🌟 Key Features
Concurrent Processing:
Uses multiple worker threads (Consumers) to distribute the
stemming workload and achieve high throughput.
Producer/Consumer Pattern:
Organizes data flow across two synchronized queues 
(BlockingQueue) to prevent race conditions and manage flow control.
Decoupled I/O:
Separates slow file reading/writing (I/O) from fast, in-memory processing 
(Stemming).
Target Output: 
Extracts and collects a final list of unique stems found in the input file.
⚙️ Project Architecture
The system is divided into three main stages connected via two blocking queues.
Stemming 


                   
Stemming (Main):   Setup and Initialization                 
                                     
Producer:           File Reader            
                                                           
MultipleConsumers: Concurrent Stemming     
                    
SingleConsumerWrite: Collector            
                    and Writer           



