package hackingrace;

public class VaultHackingRace {
public static void main(String[] args){
    Vault vault=new Vault();
        Thread ascendingHacker = new AscendingHackerThread(vault);
        Thread descendingHacker = new DescendingHackerThread(vault);
        Thread policeThread = new PoliceThread();

        // 3. يستخدم أولوية Thread.MAX_PRIORITY لنياسب القراصنة [cite: 28, 45]
        ascendingHacker.setPriority(Thread.MAX_PRIORITY);
        descendingHacker.setPriority(Thread.MAX_PRIORITY);

        // نيسب الشرطة يعمل بالأولوية الافتراضية (عادةً NORM_PRIORITY)

        // 4. يُطلق النياسب الثلاثة في نفس الوقت [cite: 27]
        policeThread.start();
        ascendingHacker.start();
        descendingHacker.start();
        System.out.println("--- Vault Hacking Race Started ---");
        System.out.println("Two hackers are competing to find the password (0-9999).");
        System.out.println("Police arrive in 10 seconds. Hackers have MAX_PRIORITY.");
        System.out.println("------------------------------------");
        // البرنامج ينتظر حتى يُنهي System.exit(0)
    }


}
