package com.distributed.search;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.*;

public class SearchEngine {
    private final String dataDirectory;

    public SearchEngine(String dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public Map<String, Double> calculateTFForFiles(List<String> fileNames, String query) {
        Map<String, Double> results = new HashMap<>();
        if (query == null || query.isEmpty()) return results;

        // 1. تقسيم جملة البحث إلى كلمات (Tokens)
        String[] queryWords = query.toLowerCase().trim().split("\\s+");

        for (String fileName : fileNames) {
            try {
                Path path = Paths.get(dataDirectory, fileName);
                if (!Files.exists(path)) continue;

                String content = Files.readString(path).toLowerCase();

                // 2. تقسيم محتوى الملف مع دعم الحروف العربية والإنجليزية والرموز
                String[] allWords = content.split("[\\s\\p{Punct}]+");

                if (allWords.length == 0) {
                    results.put(fileName, 0.0);
                    continue;
                }

                // 3. حساب التكرار التراكمي لجميع كلمات الاستعلام
                double cumulativeTf = 0;
                for (String qWord : queryWords) {
                    long count = Arrays.stream(allWords)
                            .filter(word -> word.equals(qWord))
                            .count();

                    // إضافة TF الكلمة الحالية إلى المجموع
                    cumulativeTf += (double) count / allWords.length;
                }

                // نضع النتيجة فقط إذا كان هناك تطابق لواحدة على الأقل من الكلمات
                if (cumulativeTf > 0) {
                    results.put(fileName, cumulativeTf);
                }

            } catch (Exception e) {
                System.err.println("[SearchEngine] Error processing " + fileName + ": " + e.getMessage());
            }
        }
        return results;
    }
}