package com.distributed.search;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListenerAdapter;

public class LeaderElectionManager {
    private static final String ELECTION_PATH = "/election";
    private final LeaderSelector leaderSelector;

    public LeaderElectionManager(CuratorFramework client, Runnable onLeadershipGained) {
        this.leaderSelector = new LeaderSelector(client, ELECTION_PATH, new LeaderSelectorListenerAdapter() {
            @Override
            public void takeLeadership(CuratorFramework client) throws Exception {
                System.out.println("[Election] Leadership gained! Starting Coordinator...");

                // التعديل الجوهري: تشغيل القائد في خيط جديد
                // لكي لا يتوقف خيط Curator عند سطر الـ Scanner في المنسق
                Thread leaderThread = new Thread(onLeadershipGained);
                leaderThread.setName("Leader-Coordinator-Thread");
                leaderThread.start();

                try {
                    // مراقبة خيط القائد. طالما هو يعمل، نحن القادة.
                    while (leaderThread.isAlive() && !Thread.currentThread().isInterrupted()) {
                        Thread.sleep(2000); // تفقد الحالة كل ثانيتين
                    }
                } catch (InterruptedException e) {
                    System.out.println("[Election] Leadership interrupted.");
                } finally {
                    System.out.println("[Election] Relinquishing leadership.");
                }
            }
        });
        this.leaderSelector.autoRequeue();
    }

    public void start() {
        System.out.println("[Election] Connecting to remote ZooKeeper and joining election...");
        leaderSelector.start();
    }
}