package com.distributed.search;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.*;

public class SearchEngine {
    private final String dataDirectory;

    public SearchEngine(String dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public Map<String, Double> calculateTFForFiles(List<String> fileNames, String term) {
        Map<String, Double> results = new HashMap<>();
        for (String fileName : fileNames) {
            try {
                Path path = Paths.get(dataDirectory, fileName);
                if (!Files.exists(path)) continue;
                String content = Files.readString(path).toLowerCase();
                String[] words = content.split("\\W+");
                long count = Arrays.stream(words).filter(w -> w.equals(term.toLowerCase())).count();
                double tf = (words.length > 0) ? (double) count / words.length : 0;
                results.put(fileName, tf);
            } catch (Exception e) {
                System.err.println("Error reading file: " + fileName);
            }
        }
        return results;
    }
}