package com.distributed.search;

import com.distributed.search.model.SearchTask;
import com.distributed.search.model.TaskResult;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;

public class SearchApplication {
    private static final String ZK_ADDRESS = "172.29.3.101:2181";
    private static final String DATA_DIR = "D:\\search_data";

    public static void main(String[] args) throws Exception {
        CuratorFramework client = CuratorFrameworkFactory.newClient(ZK_ADDRESS, new ExponentialBackoffRetry(1000, 3));
        client.start();

        ServiceRegistry registry = new ServiceRegistry(client);
        SearchEngine engine = new SearchEngine(DATA_DIR);

        // Leader Election Setup
        registry.startLeaderElection(() -> {
            System.out.println("I am now the Leader (COORDINATOR)");
            new Thread(() -> {
                try {
                    new Coordinator(registry, DATA_DIR).start();
                } catch (Exception e) { e.printStackTrace(); }
            }).start();
        });

        // Worker Server Setup
        ServerSocket serverSocket = new ServerSocket(0);
        int port = serverSocket.getLocalPort();
        new Thread(() -> {
            System.out.println("[Worker] Listening on port: " + port);
            while (true) {
                try (Socket socket = serverSocket.accept()) {
                    SearchTask task = SearchTask.parseDelimitedFrom(socket.getInputStream());
                    if (task != null) {
                        Map<String, Double> tf = engine.calculateTFForFiles(task.getFilePathsList(), task.getQuery());
                        TaskResult.newBuilder().putAllDocTfScores(tf).build().writeDelimitedTo(socket.getOutputStream());
                    }
                } catch (Exception e) { }
            }
        }).start();

        // Node Registration
        registry.registerWorker(port);
        Thread.sleep(Long.MAX_VALUE);
    }
}