/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.OptionalSslHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.common.ClientX509Util;
import org.apache.zookeeper.common.NettyUtils;
import org.apache.zookeeper.common.X509Exception;
import org.apache.zookeeper.common.ZKConfig;
import org.apache.zookeeper.server.NettyServerCnxn;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerMetrics;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.auth.ProviderRegistry;
import org.apache.zookeeper.server.auth.X509AuthenticationProvider;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServerCnxnFactory
extends ServerCnxnFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NettyServerCnxnFactory.class);
    public static final String PORT_UNIFICATION_KEY = "zookeeper.client.portUnification";
    public static final String EARLY_DROP_SECURE_CONNECTION_HANDSHAKES = "zookeeper.netty.server.earlyDropSecureConnectionHandshakes";
    private final boolean shouldUsePortUnification;
    private static final byte TLS_HANDSHAKE_RECORD_TYPE = 22;
    private final AtomicInteger outstandingHandshake = new AtomicInteger();
    public static final String OUTSTANDING_HANDSHAKE_LIMIT = "zookeeper.netty.server.outstandingHandshake.limit";
    private int outstandingHandshakeLimit;
    private boolean handshakeThrottlingEnabled;
    private final ServerBootstrap bootstrap;
    private Channel parentChannel;
    private final ChannelGroup allChannels = new DefaultChannelGroup("zkServerCnxns", new DefaultEventExecutor());
    private final Map<InetAddress, AtomicInteger> ipMap = new ConcurrentHashMap<InetAddress, AtomicInteger>();
    private InetSocketAddress localAddress;
    private int maxClientCnxns = 60;
    int listenBacklog = -1;
    private final ClientX509Util x509Util;
    public static final String NETTY_ADVANCED_FLOW_CONTROL = "zookeeper.netty.advancedFlowControl.enabled";
    private boolean advancedFlowControlEnabled = false;
    private static final AttributeKey<NettyServerCnxn> CONNECTION_ATTRIBUTE = AttributeKey.valueOf("NettyServerCnxn");
    private static final AtomicReference<ByteBufAllocator> TEST_ALLOCATOR = new AtomicReference<Object>(null);
    public static final String CLIENT_CERT_RELOAD_KEY = "zookeeper.client.certReload";
    CnxnChannelHandler channelHandler = new CnxnChannelHandler();
    ReadIssuedTrackingHandler readIssuedTrackingHandler = new ReadIssuedTrackingHandler();
    private boolean killed;

    public void setOutstandingHandshakeLimit(int limit) {
        this.outstandingHandshakeLimit = limit;
        this.handshakeThrottlingEnabled = (this.secure || this.shouldUsePortUnification) && this.outstandingHandshakeLimit > 0;
        LOG.info("handshakeThrottlingEnabled = {}, {} = {}", this.handshakeThrottlingEnabled, OUTSTANDING_HANDSHAKE_LIMIT, this.outstandingHandshakeLimit);
    }

    private void updateHandshakeCountIfStarted(NettyServerCnxn cnxn) {
        if (cnxn != null && cnxn.getHandshakeState() == NettyServerCnxn.HandshakeState.STARTED) {
            cnxn.setHandshakeState(NettyServerCnxn.HandshakeState.FINISHED);
            this.outstandingHandshake.addAndGet(-1);
        }
    }

    private ServerBootstrap configureBootstrapAllocator(ServerBootstrap bootstrap) {
        ByteBufAllocator testAllocator = TEST_ALLOCATOR.get();
        if (testAllocator != null) {
            return ((ServerBootstrap)bootstrap.option(ChannelOption.ALLOCATOR, testAllocator)).childOption(ChannelOption.ALLOCATOR, testAllocator);
        }
        return bootstrap;
    }

    NettyServerCnxnFactory() {
        this.x509Util = new ClientX509Util();
        boolean useClientReload = Boolean.getBoolean(CLIENT_CERT_RELOAD_KEY);
        LOG.info("{}={}", (Object)CLIENT_CERT_RELOAD_KEY, (Object)useClientReload);
        if (useClientReload) {
            try {
                this.x509Util.enableCertFileReloading();
            }
            catch (IOException e) {
                LOG.error("unable to set up client certificate reload filewatcher", e);
                useClientReload = false;
            }
        }
        boolean usePortUnification = Boolean.getBoolean(PORT_UNIFICATION_KEY);
        LOG.info("{}={}", (Object)PORT_UNIFICATION_KEY, (Object)usePortUnification);
        if (usePortUnification) {
            try {
                QuorumPeerConfig.configureSSLAuth();
            }
            catch (QuorumPeerConfig.ConfigException e) {
                LOG.error("unable to set up SslAuthProvider, turning off client port unification", e);
                usePortUnification = false;
            }
        }
        this.shouldUsePortUnification = usePortUnification;
        this.advancedFlowControlEnabled = Boolean.getBoolean(NETTY_ADVANCED_FLOW_CONTROL);
        LOG.info("{} = {}", (Object)NETTY_ADVANCED_FLOW_CONTROL, (Object)this.advancedFlowControlEnabled);
        this.setOutstandingHandshakeLimit(Integer.getInteger(OUTSTANDING_HANDSHAKE_LIMIT, -1));
        EventLoopGroup bossGroup = NettyUtils.newNioOrEpollEventLoopGroup(NettyUtils.getClientReachableLocalInetAddressCount());
        EventLoopGroup workerGroup = NettyUtils.newNioOrEpollEventLoopGroup();
        ServerBootstrap bootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(bossGroup, workerGroup).channel(NettyUtils.nioOrEpollServerSocketChannel())).option(ChannelOption.SO_REUSEADDR, true)).childOption(ChannelOption.TCP_NODELAY, true).childOption(ChannelOption.SO_LINGER, -1).childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                if (NettyServerCnxnFactory.this.advancedFlowControlEnabled) {
                    pipeline.addLast(NettyServerCnxnFactory.this.readIssuedTrackingHandler);
                }
                if (NettyServerCnxnFactory.this.secure) {
                    NettyServerCnxnFactory.this.initSSL(pipeline, false);
                } else if (NettyServerCnxnFactory.this.shouldUsePortUnification) {
                    NettyServerCnxnFactory.this.initSSL(pipeline, true);
                }
                pipeline.addLast("servercnxnfactory", (ChannelHandler)NettyServerCnxnFactory.this.channelHandler);
            }
        });
        this.bootstrap = this.configureBootstrapAllocator(bootstrap);
        this.bootstrap.validate();
    }

    private synchronized void initSSL(ChannelPipeline p, boolean supportPlaintext) throws X509Exception, SSLException {
        SslContext nettySslContext;
        String authProviderProp = System.getProperty(this.x509Util.getSslAuthProviderProperty());
        if (authProviderProp == null) {
            nettySslContext = this.x509Util.createNettySslContextForServer(new ZKConfig());
        } else {
            X509AuthenticationProvider authProvider = (X509AuthenticationProvider)ProviderRegistry.getProvider(System.getProperty(this.x509Util.getSslAuthProviderProperty(), "x509"));
            if (authProvider == null) {
                LOG.error("Auth provider not found: {}", (Object)authProviderProp);
                throw new X509Exception.SSLContextException("Could not create SSLContext with specified auth provider: " + authProviderProp);
            }
            nettySslContext = this.x509Util.createNettySslContextForServer(new ZKConfig(), authProvider.getKeyManager(), authProvider.getTrustManager());
        }
        if (supportPlaintext) {
            p.addLast("ssl", (ChannelHandler)new DualModeSslHandler(nettySslContext));
            LOG.debug("dual mode SSL handler added for channel: {}", (Object)p.channel());
        } else {
            p.addLast("ssl", (ChannelHandler)nettySslContext.newHandler(p.channel().alloc()));
            LOG.debug("SSL handler added for channel: {}", (Object)p.channel());
        }
    }

    @Override
    public void closeAll(ServerCnxn.DisconnectReason reason) {
        LOG.debug("closeAll()");
        int length = this.cnxns.size();
        for (ServerCnxn cnxn : this.cnxns) {
            try {
                cnxn.close(reason);
            }
            catch (Exception e) {
                LOG.warn("Ignoring exception closing cnxn sessionid 0x{}", (Object)Long.toHexString(cnxn.getSessionId()), (Object)e);
            }
        }
        LOG.debug("allChannels size: {} cnxns size: {}", (Object)this.allChannels.size(), (Object)length);
    }

    @Override
    public void configure(InetSocketAddress addr, int maxClientCnxns, int backlog, boolean secure) throws IOException {
        this.configureSaslLogin();
        this.initMaxCnxns();
        this.localAddress = addr;
        this.maxClientCnxns = maxClientCnxns;
        this.secure = secure;
        this.listenBacklog = backlog;
        LOG.info("configure {} secure: {} on addr {}", this, secure, addr);
    }

    @Override
    public int getMaxClientCnxnsPerHost() {
        return this.maxClientCnxns;
    }

    @Override
    public void setMaxClientCnxnsPerHost(int max) {
        this.maxClientCnxns = max;
    }

    @Override
    public int getSocketListenBacklog() {
        return this.listenBacklog;
    }

    @Override
    public int getLocalPort() {
        return this.localAddress.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void join() throws InterruptedException {
        NettyServerCnxnFactory nettyServerCnxnFactory = this;
        synchronized (nettyServerCnxnFactory) {
            while (!this.killed) {
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        NettyServerCnxnFactory nettyServerCnxnFactory = this;
        synchronized (nettyServerCnxnFactory) {
            if (this.killed) {
                LOG.info("already shutdown {}", (Object)this.localAddress);
                return;
            }
        }
        LOG.info("shutdown called {}", (Object)this.localAddress);
        this.x509Util.close();
        if (this.login != null) {
            this.login.shutdown();
        }
        EventLoopGroup bossGroup = this.bootstrap.config().group();
        EventLoopGroup workerGroup = this.bootstrap.config().childGroup();
        if (this.parentChannel != null) {
            ChannelFuture parentCloseFuture = this.parentChannel.close();
            if (bossGroup != null) {
                parentCloseFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> bossGroup.shutdownGracefully()));
            }
            this.closeAll(ServerCnxn.DisconnectReason.SERVER_SHUTDOWN);
            ChannelGroupFuture allChannelsCloseFuture = this.allChannels.close();
            if (workerGroup != null) {
                allChannelsCloseFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> workerGroup.shutdownGracefully()));
            }
        } else {
            if (bossGroup != null) {
                bossGroup.shutdownGracefully();
            }
            if (workerGroup != null) {
                workerGroup.shutdownGracefully();
            }
        }
        if (this.zkServer != null) {
            this.zkServer.shutdown();
        }
        NettyServerCnxnFactory nettyServerCnxnFactory2 = this;
        synchronized (nettyServerCnxnFactory2) {
            this.killed = true;
            this.notifyAll();
        }
    }

    @Override
    public void start() {
        if (this.listenBacklog != -1) {
            this.bootstrap.option(ChannelOption.SO_BACKLOG, this.listenBacklog);
        }
        LOG.info("binding to port {}", (Object)this.localAddress);
        this.parentChannel = this.bootstrap.bind(this.localAddress).syncUninterruptibly().channel();
        this.localAddress = (InetSocketAddress)this.parentChannel.localAddress();
        LOG.info("bound to port {}", (Object)this.getLocalPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconfigure(InetSocketAddress addr) {
        LOG.info("binding to port {}, {}", (Object)addr, (Object)this.localAddress);
        if (addr != null && this.localAddress != null && (addr.equals(this.localAddress) || addr.getAddress().isAnyLocalAddress() && this.localAddress.getAddress().isAnyLocalAddress() && addr.getPort() == this.localAddress.getPort())) {
            LOG.info("address is the same, skip rebinding");
            return;
        }
        try (Channel oldChannel = this.parentChannel;){
            this.parentChannel = this.bootstrap.bind(addr).syncUninterruptibly().channel();
            this.localAddress = (InetSocketAddress)this.parentChannel.localAddress();
            LOG.info("bound to port {}", (Object)this.getLocalPort());
        }
    }

    @Override
    public void startup(ZooKeeperServer zks, boolean startServer) throws IOException, InterruptedException {
        this.start();
        this.setZooKeeperServer(zks);
        if (startServer) {
            zks.startdata();
            zks.startup();
        }
    }

    @Override
    public Iterable<ServerCnxn> getConnections() {
        return this.cnxns;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    private void addCnxn(NettyServerCnxn cnxn) {
        this.cnxns.add(cnxn);
        InetAddress addr = ((InetSocketAddress)cnxn.getChannel().remoteAddress()).getAddress();
        this.ipMap.compute(addr, (a, cnxnCount) -> {
            if (cnxnCount == null) {
                cnxnCount = new AtomicInteger();
            }
            cnxnCount.incrementAndGet();
            return cnxnCount;
        });
    }

    void removeCnxnFromIpMap(NettyServerCnxn cnxn, InetAddress remoteAddress) {
        this.ipMap.compute(remoteAddress, (addr, cnxnCount) -> {
            if (cnxnCount == null) {
                LOG.error("Unexpected remote address {} when removing cnxn {}", (Object)remoteAddress, (Object)cnxn);
                return null;
            }
            int newValue = cnxnCount.decrementAndGet();
            return newValue == 0 ? null : cnxnCount;
        });
    }

    private int getClientCnxnCount(InetAddress addr) {
        AtomicInteger count = this.ipMap.get(addr);
        return count == null ? 0 : count.get();
    }

    @Override
    public void resetAllConnectionStats() {
        for (ServerCnxn c : this.cnxns) {
            c.resetStats();
        }
    }

    @Override
    public Iterable<Map<String, Object>> getAllConnectionInfo(boolean brief) {
        HashSet<Map<String, Object>> info = new HashSet<Map<String, Object>>();
        for (ServerCnxn c : this.cnxns) {
            info.add(c.getConnectionInfo(brief));
        }
        return info;
    }

    static void setTestAllocator(ByteBufAllocator allocator) {
        TEST_ALLOCATOR.set(allocator);
    }

    static void clearTestAllocator() {
        TEST_ALLOCATOR.set(null);
    }

    public void setAdvancedFlowControlEnabled(boolean advancedFlowControlEnabled) {
        this.advancedFlowControlEnabled = advancedFlowControlEnabled;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public Channel getParentChannel() {
        return this.parentChannel;
    }

    public int getOutstandingHandshakeNum() {
        return this.outstandingHandshake.get();
    }

    @ChannelHandler.Sharable
    static class ReadIssuedTrackingHandler
    extends ChannelDuplexHandler {
        ReadIssuedTrackingHandler() {
        }

        @Override
        public void read(ChannelHandlerContext ctx) throws Exception {
            NettyServerCnxn cnxn = (NettyServerCnxn)ctx.channel().attr(CONNECTION_ATTRIBUTE).get();
            if (cnxn != null) {
                ++cnxn.readIssuedAfterReadComplete;
            }
            ctx.read();
        }

        @Override
        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            NettyServerCnxn cnxn = (NettyServerCnxn)ctx.channel().attr(CONNECTION_ATTRIBUTE).get();
            if (cnxn != null) {
                cnxn.readIssuedAfterReadComplete = 0;
            }
            ctx.fireChannelReadComplete();
        }
    }

    final class CertificateVerifier
    implements GenericFutureListener<Future<Channel>> {
        private final SslHandler sslHandler;
        private final NettyServerCnxn cnxn;

        CertificateVerifier(SslHandler sslHandler, NettyServerCnxn cnxn) {
            this.sslHandler = sslHandler;
            this.cnxn = cnxn;
        }

        @Override
        public void operationComplete(Future<Channel> future) {
            NettyServerCnxnFactory.this.updateHandshakeCountIfStarted(this.cnxn);
            if (future.isSuccess()) {
                LOG.debug("Successful handshake with session 0x{}", (Object)Long.toHexString(this.cnxn.getSessionId()));
                SSLEngine eng = this.sslHandler.engine();
                if (eng.getNeedClientAuth() || eng.getWantClientAuth()) {
                    SSLSession session = eng.getSession();
                    try {
                        this.cnxn.setClientCertificateChain(session.getPeerCertificates());
                    }
                    catch (SSLPeerUnverifiedException e) {
                        if (eng.getNeedClientAuth()) {
                            LOG.error("Error getting peer certificates", e);
                            this.cnxn.close();
                            return;
                        }
                        Channel futureChannel = future.getNow();
                        NettyServerCnxnFactory.this.allChannels.add(Objects.requireNonNull(futureChannel));
                        NettyServerCnxnFactory.this.addCnxn(this.cnxn);
                        return;
                    }
                    catch (Exception e) {
                        LOG.error("Error getting peer certificates", e);
                        this.cnxn.close();
                        return;
                    }
                    String authProviderProp = System.getProperty(NettyServerCnxnFactory.this.x509Util.getSslAuthProviderProperty(), "x509");
                    X509AuthenticationProvider authProvider = (X509AuthenticationProvider)ProviderRegistry.getProvider(authProviderProp);
                    if (authProvider == null) {
                        LOG.error("X509 Auth provider not found: {}", (Object)authProviderProp);
                        this.cnxn.close(ServerCnxn.DisconnectReason.AUTH_PROVIDER_NOT_FOUND);
                        return;
                    }
                    KeeperException.Code code = authProvider.handleAuthentication(this.cnxn, null);
                    if (KeeperException.Code.OK != code) {
                        NettyServerCnxnFactory.this.zkServer.serverStats().incrementAuthFailedCount();
                        LOG.error("Authentication failed for session 0x{}", (Object)Long.toHexString(this.cnxn.getSessionId()));
                        this.cnxn.close(ServerCnxn.DisconnectReason.SASL_AUTH_FAILURE);
                        return;
                    }
                }
                Channel futureChannel = future.getNow();
                NettyServerCnxnFactory.this.allChannels.add(Objects.requireNonNull(futureChannel));
                NettyServerCnxnFactory.this.addCnxn(this.cnxn);
            } else {
                NettyServerCnxnFactory.this.zkServer.serverStats().incrementAuthFailedCount();
                LOG.error("Unsuccessful handshake with session 0x{}", (Object)Long.toHexString(this.cnxn.getSessionId()));
                ServerMetrics.getMetrics().UNSUCCESSFUL_HANDSHAKE.add(1L);
                this.cnxn.close(ServerCnxn.DisconnectReason.FAILED_HANDSHAKE);
            }
        }
    }

    @ChannelHandler.Sharable
    class CnxnChannelHandler
    extends ChannelDuplexHandler {
        private final GenericFutureListener<Future<Void>> onWriteCompletedTracer = f -> {
            if (LOG.isTraceEnabled()) {
                LOG.trace("write success: {}", (Object)f.isSuccess());
            }
        };

        CnxnChannelHandler() {
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            boolean earlyDropSecureConnectionHandshakes;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Channel active {}", (Object)ctx.channel());
            }
            Channel channel = ctx.channel();
            if (NettyServerCnxnFactory.this.limitTotalNumberOfCnxns()) {
                ServerMetrics.getMetrics().CONNECTION_REJECTED.add(1L);
                channel.close();
                return;
            }
            InetAddress addr = ((InetSocketAddress)channel.remoteAddress()).getAddress();
            if (NettyServerCnxnFactory.this.maxClientCnxns > 0 && NettyServerCnxnFactory.this.getClientCnxnCount(addr) >= NettyServerCnxnFactory.this.maxClientCnxns) {
                ServerMetrics.getMetrics().CONNECTION_REJECTED.add(1L);
                LOG.warn("Too many connections from {} - max is {}", (Object)addr, (Object)NettyServerCnxnFactory.this.maxClientCnxns);
                channel.close();
                return;
            }
            NettyServerCnxn cnxn = new NettyServerCnxn(channel, NettyServerCnxnFactory.this.zkServer, NettyServerCnxnFactory.this);
            ctx.channel().attr(CONNECTION_ATTRIBUTE).set(cnxn);
            if (NettyServerCnxnFactory.this.secure && !cnxn.isZKServerRunning() && (earlyDropSecureConnectionHandshakes = Boolean.getBoolean(NettyServerCnxnFactory.EARLY_DROP_SECURE_CONNECTION_HANDSHAKES))) {
                LOG.info("Zookeeper server is not running, close the connection to {} before starting the TLS handshake", (Object)cnxn.getChannel().remoteAddress());
                ServerMetrics.getMetrics().CNXN_CLOSED_WITHOUT_ZK_SERVER_RUNNING.add(1L);
                channel.close();
                return;
            }
            if (NettyServerCnxnFactory.this.handshakeThrottlingEnabled) {
                int outstandingHandshakesNum = NettyServerCnxnFactory.this.outstandingHandshake.addAndGet(1);
                if (outstandingHandshakesNum > NettyServerCnxnFactory.this.outstandingHandshakeLimit) {
                    NettyServerCnxnFactory.this.outstandingHandshake.addAndGet(-1);
                    channel.close();
                    ServerMetrics.getMetrics().TLS_HANDSHAKE_EXCEEDED.add(1L);
                } else {
                    cnxn.setHandshakeState(NettyServerCnxn.HandshakeState.STARTED);
                }
            }
            if (NettyServerCnxnFactory.this.secure) {
                SslHandler sslHandler = ctx.pipeline().get(SslHandler.class);
                Future<Channel> handshakeFuture = sslHandler.handshakeFuture();
                handshakeFuture.addListener(new CertificateVerifier(sslHandler, cnxn));
            } else if (!NettyServerCnxnFactory.this.shouldUsePortUnification) {
                NettyServerCnxnFactory.this.allChannels.add(ctx.channel());
                NettyServerCnxnFactory.this.addCnxn(cnxn);
            }
            if (ctx.channel().pipeline().get(SslHandler.class) == null) {
                if (NettyServerCnxnFactory.this.zkServer != null) {
                    SocketAddress remoteAddress = cnxn.getChannel().remoteAddress();
                    if (remoteAddress != null && !((InetSocketAddress)remoteAddress).getAddress().isLoopbackAddress()) {
                        LOG.trace("NettyChannelHandler channelActive: remote={} local={}", (Object)remoteAddress, (Object)cnxn.getChannel().localAddress());
                        NettyServerCnxnFactory.this.zkServer.serverStats().incrementNonMTLSRemoteConnCount();
                    } else {
                        NettyServerCnxnFactory.this.zkServer.serverStats().incrementNonMTLSLocalConnCount();
                    }
                } else {
                    LOG.trace("Opened non-TLS connection from {} but zkServer is not running", (Object)cnxn.getChannel().remoteAddress());
                }
            }
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Channel inactive {}", (Object)ctx.channel());
            }
            NettyServerCnxnFactory.this.allChannels.remove(ctx.channel());
            NettyServerCnxn cnxn = ctx.channel().attr(CONNECTION_ATTRIBUTE).getAndSet(null);
            if (cnxn != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Channel inactive caused close {}", (Object)cnxn);
                }
                NettyServerCnxnFactory.this.updateHandshakeCountIfStarted(cnxn);
                cnxn.close(ServerCnxn.DisconnectReason.CHANNEL_DISCONNECTED);
            }
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            LOG.warn("Exception caught", cause);
            NettyServerCnxn cnxn = ctx.channel().attr(CONNECTION_ATTRIBUTE).getAndSet(null);
            if (cnxn != null) {
                LOG.debug("Closing {}", (Object)cnxn);
                NettyServerCnxnFactory.this.updateHandshakeCountIfStarted(cnxn);
                cnxn.close(ServerCnxn.DisconnectReason.CHANNEL_CLOSED_EXCEPTION);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            try {
                if (evt == NettyServerCnxn.ReadEvent.ENABLE) {
                    LOG.debug("Received ReadEvent.ENABLE");
                    NettyServerCnxn cnxn = (NettyServerCnxn)ctx.channel().attr(CONNECTION_ATTRIBUTE).get();
                    if (cnxn != null && cnxn.getQueuedReadableBytes() > 0) {
                        cnxn.processQueuedBuffer();
                        if (NettyServerCnxnFactory.this.advancedFlowControlEnabled && cnxn.getQueuedReadableBytes() == 0) {
                            ctx.read();
                            LOG.debug("Issued a read after queuedBuffer drained");
                        }
                    }
                    if (!NettyServerCnxnFactory.this.advancedFlowControlEnabled) {
                        ctx.channel().config().setAutoRead(true);
                    }
                } else if (evt == NettyServerCnxn.ReadEvent.DISABLE) {
                    LOG.debug("Received ReadEvent.DISABLE");
                    ctx.channel().config().setAutoRead(false);
                }
            }
            finally {
                ReferenceCountUtil.release(evt);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("message received called {}", msg);
                }
                try {
                    LOG.debug("New message {} from {}", msg, (Object)ctx.channel());
                    NettyServerCnxn cnxn = (NettyServerCnxn)ctx.channel().attr(CONNECTION_ATTRIBUTE).get();
                    if (cnxn == null) {
                        LOG.error("channelRead() on a closed or closing NettyServerCnxn");
                    } else {
                        cnxn.processMessage((ByteBuf)msg);
                    }
                }
                catch (Exception ex) {
                    LOG.error("Unexpected exception in receive", ex);
                    throw ex;
                }
            }
            finally {
                ReferenceCountUtil.release(msg);
            }
        }

        @Override
        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            NettyServerCnxn cnxn;
            if (NettyServerCnxnFactory.this.advancedFlowControlEnabled && (cnxn = (NettyServerCnxn)ctx.channel().attr(CONNECTION_ATTRIBUTE).get()) != null && cnxn.getQueuedReadableBytes() == 0 && cnxn.readIssuedAfterReadComplete == 0) {
                ctx.read();
                LOG.debug("Issued a read since we do not have anything to consume after channelReadComplete");
            }
            ctx.fireChannelReadComplete();
        }

        @Override
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (LOG.isTraceEnabled()) {
                promise.addListener((GenericFutureListener<? extends Future<? super Void>>)this.onWriteCompletedTracer);
            }
            super.write(ctx, msg, promise);
        }
    }

    class DualModeSslHandler
    extends OptionalSslHandler {
        DualModeSslHandler(SslContext sslContext) {
            super(sslContext);
        }

        @Override
        protected void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out) throws Exception {
            if (in.readableBytes() >= 5) {
                super.decode(context, in, out);
            } else if (in.readableBytes() > 0 && 22 != in.getByte(0)) {
                LOG.debug("first byte {} does not match TLS handshake, failing to plaintext", (Object)in.getByte(0));
                this.handleNonSsl(context);
            }
        }

        private void handleNonSsl(ChannelHandlerContext context) {
            ChannelHandler handler = this.newNonSslHandler(context);
            if (handler != null) {
                context.pipeline().replace(this, this.newNonSslHandlerName(), handler);
            } else {
                context.pipeline().remove(this);
            }
        }

        @Override
        protected SslHandler newSslHandler(ChannelHandlerContext context, SslContext sslContext) {
            NettyServerCnxn cnxn = Objects.requireNonNull((NettyServerCnxn)context.channel().attr(CONNECTION_ATTRIBUTE).get());
            LOG.debug("creating ssl handler for session {}", (Object)cnxn.getSessionId());
            SslHandler handler = super.newSslHandler(context, sslContext);
            Future<Channel> handshakeFuture = handler.handshakeFuture();
            handshakeFuture.addListener(new CertificateVerifier(handler, cnxn));
            return handler;
        }

        @Override
        protected ChannelHandler newNonSslHandler(ChannelHandlerContext context) {
            NettyServerCnxn cnxn = Objects.requireNonNull((NettyServerCnxn)context.channel().attr(CONNECTION_ATTRIBUTE).get());
            LOG.debug("creating plaintext handler for session {}", (Object)cnxn.getSessionId());
            NettyServerCnxnFactory.this.updateHandshakeCountIfStarted(cnxn);
            NettyServerCnxnFactory.this.allChannels.add(context.channel());
            NettyServerCnxnFactory.this.addCnxn(cnxn);
            return super.newNonSslHandler(context);
        }
    }
}

