import junit.framework.TestCase;

public class ThreadPoolTest extends TestCase {
    public void testExecuteWithLargeNumberOfTasks() throws InterruptedException {
        // Create a ThreadPool with 2 threads and a queue size of 5
        ThreadPool threadPool = new ThreadPool(2, 5);

        // Add tasks to the ThreadPool
        for (int i = 0; i < 100; i++) {
            int taskId = i;
            threadPool.execute(() -> {
                System.out.println("Task " + taskId + " is running on thread " + Thread.currentThread().getId());
                try {
                    Thread.sleep(100); // Simulate some work
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            });
        }

        // Wait for all tasks to finish
        threadPool.waitUntilAllTaskFinished(500);

        // Stop the ThreadPool
        threadPool.stop();

        // Assert that the ThreadPool stopped correctly
        assertTrue(threadPool.isStopped());
    }

    public void testWaitUntilAllTaskFinished() throws InterruptedException {
        // Create a ThreadPool with 2 threads and a queue size of 200
        ThreadPool threadPool = new ThreadPool(2, 200);

        // Add tasks to the ThreadPool
        for (int i = 0; i < 3; i++) {
            int taskId = i;
            threadPool.execute(() -> {
                System.out.println("Task " + taskId + " is running on thread " + Thread.currentThread().getId());
                try {
                    Thread.sleep(500); // Simulate some work
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            });
        }

        // Wait for all tasks to finish
        threadPool.waitUntilAllTaskFinished(10);

        // Assert that the ThreadPool stopped correctly
        assertTrue(threadPool.isStopped());
    }

    public void testThreadPool() throws InterruptedException {
        // Create a ThreadPool with 2 threads and a queue size of 5
        ThreadPool threadPool = new ThreadPool(2, 5);

        // Add tasks to the ThreadPool
        for (int i = 0; i < 10; i++) {
            int taskId = i;
            threadPool.execute(() -> {
                System.out.println("Task " + taskId + " is running on thread " + Thread.currentThread().getId());
                try {
                    Thread.sleep(100); // Simulate some work
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            });
        }

        // Wait for all tasks to finish with a timeout of 1000 milliseconds
        threadPool.waitUntilAllTaskFinished(1000);

        // Stop the ThreadPool
        threadPool.stop();

        // Assert that the ThreadPool stopped correctly
        assertTrue(threadPool.isStopped());
    }


    public void testThreadPoolAfterStop() {
        // Create a ThreadPool with 1 thread and a queue size of 2
        ThreadPool threadPool = new ThreadPool(1, 2);

        // Stop the ThreadPool immediately
        threadPool.stop();

        // Try adding a task after stopping
        try {
            threadPool.execute(() -> {
                System.out.println("This task should not run.");
            });

            // If the task is added, the test fails
            fail("Should not be able to add a task after stopping the ThreadPool");
        } catch (IllegalStateException e) {
            // Expected exception
        }

        // Assert that the ThreadPool stopped correctly
        assertTrue(threadPool.isStopped());
    }
}
