# ThreadPool

The `ThreadPool` class is a lightweight and simple implementation of a thread pool in Java. It provides a convenient way to manage and execute concurrent tasks using a fixed number of threads and a task queue. This can be particularly useful in scenarios where parallel processing of tasks is required, such as in web servers, concurrent applications, or any situation where efficient task execution is essential.

## Overview

### Features

- **Concurrency:** Execute multiple tasks concurrently using a specified number of threads.

- **Task Queue:** Manage tasks efficiently with a task queue, preventing overload and optimizing resource usage.

- **Timeout Handling:** Use the `waitUntilAllTaskFinished` method to wait for all tasks to finish within a specified timeout. If the timeout is reached, the thread pool is stopped.

- **Graceful Shutdown:** Stop the thread pool using the `stop` method, gracefully interrupting all running threads.
