import counters.PrimesCounterThread;
import junit.framework.TestCase;
import org.junit.jupiter.api.BeforeAll;
import parallelcounters.*;
import worker.WorkPartitioner;

import java.util.List;

public class Tester extends TestCase {

    private static int start = 0, finish = 1000000;
    private static long result = SequentialCounter.sum(start, finish);


    private static void testAll(int threadCount) {
        assertEquals(result, ParallelCounter0.sum(start, finish, threadCount));
        assertEquals(result, ParallelCounter1.sum(start, finish, threadCount));
        assertEquals(result, ParallelCounter2.sum(start, finish, threadCount));
        assertEquals(result, ParallelCounter3.sum(start, finish, threadCount));
        assertEquals(result, ParallelCounter4.sum(start, finish, threadCount));
    }

    public void testSingleThread() {
        testAll(1);
    }

    public void testTwoThread() {
        testAll(2);
    }

    public void testSevenThread() {
        testAll(7);
    }

    public void testEightThread() {
        testAll(8);
    }

    public void test11Thread() {
        testAll(11);
    }

    public void test16Thread() {
        testAll(16);
    }
}
