package parallelcounters;

import counters.PrimesCounterThread;
import worker.WorkPartitioner;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ParallelCounter2 {

	public static long sum(int start, int finish, int threadCount) {
		
		List<PrimesCounterThread> counters =  new ArrayList<>();
		List<WorkPartitioner.Part> parts =  WorkPartitioner.partitions(start, finish, threadCount);
		
		for (WorkPartitioner.Part part : parts) {
			counters.add(new PrimesCounterThread(part));
		}
		
		//creating a pool of #threadCount threads
		ExecutorService executor = Executors.newFixedThreadPool(threadCount);
		
		for (PrimesCounterThread counter: counters) {
			executor.execute(counter);
		}
			
		executor.shutdown();
		
		//Waiting for all the thread to finalize
		while (!executor.isTerminated()) {
			//System.out.println("Processing....");
		}  
	   
	    return counters.stream().mapToLong(PrimesCounterThread::getSum).sum();
	}

	
}
