package parallelcounters;

import counters.PrimesCounterCallable;
import worker.WorkPartitioner;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ParallelCounter4 {
	
	public static long sum(int start, int finish, int threadCount) {
		
		//creating a pool of #threadCount threads
		ExecutorService executor = Executors.newFixedThreadPool(threadCount);
		List<Future<Long>> results = new ArrayList<Future<Long>>();
		List<WorkPartitioner.Part> parts =  WorkPartitioner.partitions(start, finish, threadCount);
		
		for (WorkPartitioner.Part part : parts) {
			results.add(executor.submit(new PrimesCounterCallable(part)));
		}

		executor.shutdown();
		
		while (!executor.isTerminated()) {
			//System.out.println("Processing...");
		}

	    long sum = 0;
	    for (Future<Long> future : results) {
			try {
				sum += future.get();
			} catch (InterruptedException | ExecutionException e) {
				System.err.println("Cannot get the results from threads.");
				return -2;
			}
		}

		return sum;
	}

	
}
