package parallelcounters;

import counters.PrimesCounterRunnable;
import worker.WorkPartitioner;

import java.util.ArrayList;
import java.util.List;

public class ParallelCounter1 {

	public static long sum(int start, int finish, int threadCount) {
		
		List<PrimesCounterRunnable> counters =  new ArrayList<>();
		List<WorkPartitioner.Part> parts =  WorkPartitioner.partitions(start, finish, threadCount);
		
		for (WorkPartitioner.Part part : parts) {
			counters.add(new PrimesCounterRunnable(part));
		}
		
		for (PrimesCounterRunnable CounterRunnable : counters) {
			CounterRunnable.startThread();
		}
		
		for (PrimesCounterRunnable CounterRunnable : counters) {
			try {
				CounterRunnable.joinThread();
			} catch (InterruptedException e) {
				System.err.println("Thread cannot join!");
			}
		}
		
	    long sum = 0;
	    for (PrimesCounterRunnable counterRunnable : counters) {
			sum += counterRunnable.getCnt();
		}

	    return sum;
	}

	
}
