package worker;

import java.util.ArrayList;
import java.util.List;

public class WorkPartitioner {
	
	public static List<Part> partitions(int start, int finish, int workerCount){
		List<Part> parts =  new ArrayList<>();
		int size = finish - start + 1;
		if (workerCount > size)	workerCount = size;
		int part = (int) Math.ceil( (double)size / workerCount);
		for (int i = 0; i <workerCount ; i++) {
			int s = i * part + start;
			int f = Math.min((i+1) * part, size) + start - 1;
			if(s <= f)	parts.add(new Part(s, f));	else break;
		}
		return parts;
	}

	public static class Part {
		private final int start;
		private final int finish;
		public Part(int start, int finish) {
			this.start = start;
			this.finish = finish;
		}
		public int getStart() {
			return start;
		}
		public int getFinish() {
			return finish;
		}
	}
}
