package parallelcounters;

import counters.PrimesCounterCallable;
import worker.WorkPartitioner;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ParallelCounter3 {
	
	public static long sum(int start, int finish, int threadCount) {
		
		//creating a pool of #threadCount threads  
		ExecutorService executor = Executors.newFixedThreadPool(threadCount);
		
		List<PrimesCounterCallable> counters =  new ArrayList<PrimesCounterCallable>();
		List<WorkPartitioner.Part> parts =  WorkPartitioner.partitions(start, finish, threadCount);
		
		for (WorkPartitioner.Part part : parts) {
			counters.add(new PrimesCounterCallable(part));
		}
		
		List<Future<Long>> results;
		try {
			results = executor.invokeAll(counters);
		} catch (InterruptedException e) {
			System.err.println("Cannot invoke the threads.");
			return -1;
		}
		
		executor.shutdown();
	    
	    long sum = 0;
	    for (Future<Long> future : results) {
			try {
				sum += future.get();
			} catch (InterruptedException | ExecutionException e) {
				System.err.println("Cannot get the results from threads.");
				return -2;
			}
		}
	    return sum;
	}

}
