package parallelcounters;

import counters.PrimesCounterThread;
import worker.WorkPartitioner;

import java.util.ArrayList;
import java.util.List;

public class ParallelCounter0 {

	public static long sum(int start, int finish, int threadCount) {
		
		List<PrimesCounterThread> counters =  new ArrayList<>();
		List<WorkPartitioner.Part> parts =  WorkPartitioner.partitions(start, finish, threadCount);
		
		for (WorkPartitioner.Part part : parts) {
			counters.add(new PrimesCounterThread(part));
		}
		
		for (PrimesCounterThread primesCounterThread : counters) {
			primesCounterThread.start();
		}
		
		for (PrimesCounterThread primesCounterThread : counters) {
			try {
				primesCounterThread.join();
			} catch (InterruptedException e) {
				System.err.println("Thread cannot join!");
			}
		}
		
	    
	    int sum = 0;
	    for (PrimesCounterThread primesCounterThread : counters) {
			sum += primesCounterThread.getSum();
		}

	    return sum;
	}

	
}
