package counters;

import worker.WorkPartitioner;

public class PrimesCounterThread extends Thread{
	private int start;
	private int finish;
	private long cnt;
	
	public PrimesCounterThread(int start, int finish) {
		this.start = start;
		this.finish = finish;
	}

	public PrimesCounterThread(WorkPartitioner.Part part) {
	    this(part.getStart(), part.getFinish());
	}

	@Override
	public void run() {
		this.cnt = 0;
		for (int i = start; i <= finish; i++) {
			if(isPrime(i))	cnt++;
		}
	}

	private boolean isPrime(int number) {
		if (number <= 1) {
			return false;
		}
		for (int i = 2; i <= Math.sqrt(number); i++) {
			if (number % i == 0) {
				return false;
			}
		}
		return true;
	}

	public long getSum() {
		return cnt;
	}
	
}