package counters;

import worker.WorkPartitioner;
import worker.Worker;

public class PrimesCounter extends Worker {

	protected long cnt;

	public PrimesCounter(WorkPartitioner.Part part) {
		super(part);
	}

	public long getCnt() {
		return cnt;
	}

	protected boolean isPrime(int number) {
		if (number <= 1) {
			return false;
		}
		for (int i = 2; i <= Math.sqrt(number); i++) {
			if (number % i == 0) {
				return false;
			}
		}
		return true;
	}

}
