import junit.framework.TestCase;

public class FibonacciCalculatorTest extends TestCase {
    public void testFibonacciCalculator(){
        int n = 50; // Change this to calculate different Fibonacci numbers
        FibonacciCalculator fib = new FibonacciCalculator(n);
        Thread thread1 = new Thread(fib);

        long startTime = System.currentTimeMillis();
        thread1.start();
        try {
            thread1.join();
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        long endTime = System.currentTimeMillis();
        long result = fib.getResult();
        System.out.println("Fibonacci number at position " + n + " is: " + result);
        System.out.println("\nTime taken: " + (endTime - startTime) + " milliseconds");

    }

    public void testFibonacciCalculatorUsingThreads(){
        int n = 50; // Change this to calculate different Fibonacci numbers
        FibonacciCalculator fib1 = new FibonacciCalculator(n - 1);
        FibonacciCalculator fib2 = new FibonacciCalculator(n - 2);

        Thread thread1 = new Thread(fib1);
        Thread thread2 = new Thread(fib2);

        long startTime = System.currentTimeMillis();

        thread1.start();
        thread2.start();

        try {
            thread1.join();
            thread2.join();
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        long result = fib1.getResult() + fib2.getResult();
        long endTime = System.currentTimeMillis();
        System.out.println("Fibonacci number at position " + n + " is: " + result);
        System.out.println("\nTime taken: " + (endTime - startTime) + " milliseconds");

    }

}
