import junit.framework.TestCase;

import java.util.ArrayList;
import java.util.List;

public class PrimeGeneratorTest extends TestCase {

    public void testPrimeGeneratorUsing4Threads(){
        int n = 100000000; // Range is from 1 to 100,000,000
        int numThreads = 4; // Number of Threads

        boolean[] primes = new boolean[n + 1];
        Thread[] threads = new Thread[numThreads];
        int blockSize = n / numThreads;

        long startTime = System.currentTimeMillis();

        for (int i = 0; i < numThreads; i++) {
            int start = i * blockSize + 1;
            int end = (i == numThreads - 1) ? n : (i + 1) * blockSize;
            threads[i] = new Thread(new PrimeGenerator(start, end, primes));
            threads[i].start();
        }

        try {
            for (Thread thread : threads) {
                thread.join();
            }
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        // The fifth thread collects the results
        List<Integer> finalPrimes = new ArrayList<Integer>();
        for (int i = 1; i <= n; i++) {
            if(primes[i])    finalPrimes.add(i);
        }

        long endTime = System.currentTimeMillis();

        // for (int i : finalPrimes) {
        //     System.out.print(i + " ");
        // }

        System.out.println("100,000,000 With 4 Threads: Time taken is " + (endTime - startTime) + " milliseconds");
    }

    public void testPrimeGeneratorUsing2Threads(){
        int n = 100000000; // Range is from 1 to 100,000,000
        int numThreads = 2; // Number of Threads

        boolean[] primes = new boolean[n + 1];
        Thread[] threads = new Thread[numThreads];
        int blockSize = n / numThreads;

        long startTime = System.currentTimeMillis();

        for (int i = 0; i < numThreads; i++) {
            int start = i * blockSize + 1;
            int end = (i == numThreads - 1) ? n : (i + 1) * blockSize;
            threads[i] = new Thread(new PrimeGenerator(start, end, primes));
            threads[i].start();
        }

        try {
            for (Thread thread : threads) {
                thread.join();
            }
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        // The fifth thread collects the results
        List<Integer> finalPrimes = new ArrayList<Integer>();
        for (int i = 1; i <= n; i++) {
            if(primes[i])    finalPrimes.add(i);
        }

        long endTime = System.currentTimeMillis();
        System.out.println("100,000,000 With 2 Threads: Time taken is " + (endTime - startTime) + " milliseconds");
    }

    public void testPrimeGeneratorUsing5Threads(){
        int n = 100000000; // Range is from 1 to 100,000,000
        int numThreads = 5; // Number of Threads

        boolean[] primes = new boolean[n + 1];
        Thread[] threads = new Thread[numThreads];
        int blockSize = n / numThreads;

        long startTime = System.currentTimeMillis();

        for (int i = 0; i < numThreads; i++) {
            int start = i * blockSize + 1;
            int end = (i == numThreads - 1) ? n : (i + 1) * blockSize;
            threads[i] = new Thread(new PrimeGenerator(start, end, primes));
            threads[i].start();
        }

        try {
            for (Thread thread : threads) {
                thread.join();
            }
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        // The fifth thread collects the results
        List<Integer> finalPrimes = new ArrayList<Integer>();
        for (int i = 1; i <= n; i++) {
            if(primes[i])    finalPrimes.add(i);
        }

        long endTime = System.currentTimeMillis();
        System.out.println("100,000,000 With 5 Threads: Time taken is " + (endTime - startTime) + " milliseconds");
    }

    public void testPrimeGeneratorUsing8Threads(){
        int n = 100000000; // Range is from 1 to 100,000,000
        int numThreads = 8; // Number of Threads

        boolean[] primes = new boolean[n + 1];
        Thread[] threads = new Thread[numThreads];
        int blockSize = n / numThreads;

        long startTime = System.currentTimeMillis();

        for (int i = 0; i < numThreads; i++) {
            int start = i * blockSize + 1;
            int end = (i == numThreads - 1) ? n : (i + 1) * blockSize;
            threads[i] = new Thread(new PrimeGenerator(start, end, primes));
            threads[i].start();
        }

        try {
            for (Thread thread : threads) {
                thread.join();
            }
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        // The fifth thread collects the results
        List<Integer> finalPrimes = new ArrayList<Integer>();
        for (int i = 1; i <= n; i++) {
            if(primes[i])    finalPrimes.add(i);
        }

        long endTime = System.currentTimeMillis();
        System.out.println("100,000,000 With 8 Threads: Time taken is " + (endTime - startTime) + " milliseconds");
    }


    public void testPrimeGeneratorUsing4ThreadsWithSmallerRange(){
        int n = 50000000; // Range is from 1 to 100,000,000
        int numThreads = 4; // Number of Threads

        boolean[] primes = new boolean[n + 1];
        Thread[] threads = new Thread[numThreads];
        int blockSize = n / numThreads;

        long startTime = System.currentTimeMillis();

        for (int i = 0; i < numThreads; i++) {
            int start = i * blockSize + 1;
            int end = (i == numThreads - 1) ? n : (i + 1) * blockSize;
            threads[i] = new Thread(new PrimeGenerator(start, end, primes));
            threads[i].start();
        }

        try {
            for (Thread thread : threads) {
                thread.join();
            }
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        // The fifth thread collects the results
        List<Integer> finalPrimes = new ArrayList<Integer>();
        for (int i = 1; i <= n; i++) {
            if(primes[i])    finalPrimes.add(i);
        }

        long endTime = System.currentTimeMillis();
        System.out.println("50,000,000 With 4 Threads: Time taken is " + (endTime - startTime) + " milliseconds");
    }

    public void testPrimeGeneratorUsing4ThreadsWithBiggerRange(){
        int n = 200000000; // Range is from 1 to 100,000,000
        int numThreads = 4; // Number of Threads

        boolean[] primes = new boolean[n + 1];
        Thread[] threads = new Thread[numThreads];
        int blockSize = n / numThreads;

        long startTime = System.currentTimeMillis();

        for (int i = 0; i < numThreads; i++) {
            int start = i * blockSize + 1;
            int end = (i == numThreads - 1) ? n : (i + 1) * blockSize;
            threads[i] = new Thread(new PrimeGenerator(start, end, primes));
            threads[i].start();
        }

        try {
            for (Thread thread : threads) {
                thread.join();
            }
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        // The fifth thread collects the results
        List<Integer> finalPrimes = new ArrayList<Integer>();
        for (int i = 1; i <= n; i++) {
            if(primes[i])    finalPrimes.add(i);
        }

        long endTime = System.currentTimeMillis();
        System.out.println("200,000,000 With 4 Threads: Time taken is " + (endTime - startTime) + " milliseconds");
    }

}
