public class PrimeGenerator implements Runnable {
    private int start;
    private int end;
    private boolean[] primes;

    public PrimeGenerator(int start, int end, boolean[] primes) {
        this.start = start;
        this.end = end;
        this.primes = primes;
    }

    @Override
    public void run() {
        for (int i = start; i <= end; i++) {
            primes[i] = isPrime(i);
        }
    }

    private boolean isPrime(int number) {
        if (number <= 1) {
            return false;
        }
        for (int i = 2; i <= Math.sqrt(number); i++) {
            if (number % i == 0) {
                return false;
            }
        }
        return true;
    }
}
