package command;
// Generated by CodiumAI

import command.handshake.PingCommandSender;
import org.junit.Test;
import parser.CommandParser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

import static org.junit.Assert.assertThrows;
import static org.mockito.Mockito.*;

public class PingCommandSenderTest {

    @Test
    public void test_send_command_success() throws IOException {
        CommandParser commandParser = mock(CommandParser.class);
        PingCommandSender pingCommandSender = new PingCommandSender(commandParser);
        BufferedReader bufferedReader = mock(BufferedReader.class);
        OutputStream outputStream = mock(OutputStream.class);

        when(commandParser.getResponseFromCommandArray(List.of("ping"))).thenReturn("*1\r\n$4\r\nping\r\n");

        pingCommandSender.sendCommand(bufferedReader, outputStream);

        verify(outputStream).write("*1\r\n$4\r\nping\r\n".getBytes());
        verify(outputStream).flush();
    }

}