package server;

import util.RdbFileInfo;
import util.Settings;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;

public class ServerBuilder {
    private int port = 16379;
    private String role;
    private final String[] masterPortAndHost;
    private final static ServerInfo info = ServerInfo.getInstance();
    private final Map<String, String> parameters;
    private static final RdbFileInfo rdbfileInfo = RdbFileInfo.getInstance();

    public ServerBuilder(String[] args) {
        this.parameters = Settings.extractArgs(args);
        this.port = Settings.extractPort(parameters, port);
        this.masterPortAndHost = initializeMasterPortAndHost();
    }

    public ServerBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String[] getMasterPortAndHost() {
        return Optional.ofNullable(masterPortAndHost).orElseGet(this::initializeMasterPortAndHost);
    }


    public Server build() throws IOException {
        if (role == null) {
            role = "master";
        }
        return new Server(port);
    }

    private String[] initializeMasterPortAndHost() {
        rdbfileInfo.setFile(parameters);
        return info.findRole(parameters);
    }
}
