package util;

import model.Command;

import java.util.Map;

public class CommandUtil {
    private static final Map<String, Command> COMMAND_MAP = Map.of(
            "echo", Command.ECHO,
            "ping", Command.PING,
            "set", Command.SET,
            "get", Command.GET,
            "info", Command.INFO,
            "fullrsync", Command.FULLRESYNC,
            "psync", Command.PSYNC,
            "wait", Command.WAIT,
            "replconf", Command.REPLCONF
    );

    public static Command getCommand(String command) {
        return COMMAND_MAP.entrySet().stream()
                .filter(entry -> command.toLowerCase().contains(entry.getKey()))
                .map(Map.Entry::getValue)
                .findFirst()
                .orElse(Command.UNKNOWN);
    }

}
